/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestHyphenationCompoundWordTokenFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testHyphenationWithDictionary() throws Exception {
        StringReader reader = new StringReader("min veninde som er lidt af en l\u00e6sehest");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("HyphenationCompoundWord", "hyphenator", "da_UTF8.xml", "dictionary", "da_compoundDictionary.txt").create((TokenStream)stream);
        TestHyphenationCompoundWordTokenFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"min", "veninde", "som", "er", "lidt", "af", "en", "l\u00e6sehest", "l\u00e6se", "hest"}, (int[])new int[]{1, 1, 1, 1, 1, 1, 1, 1, 0, 0});
    }

    public void testHyphenationOnly() throws Exception {
        StringReader reader = new StringReader("basketballkurv");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("HyphenationCompoundWord", "hyphenator", "da_UTF8.xml", "minSubwordSize", "2", "maxSubwordSize", "4").create((TokenStream)stream);
        TestHyphenationCompoundWordTokenFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"basketballkurv", "ba", "sket", "bal", "ball", "kurv"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestHyphenationCompoundWordTokenFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("HyphenationCompoundWord", "hyphenator", "da_UTF8.xml", "bogusArg", "bogusValue"));
        TestHyphenationCompoundWordTokenFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

