/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.CharFilter;
import org.apache.lucene.analysis.CrankyTokenFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.MockCharFilter;
import org.apache.lucene.analysis.MockFixedLengthPayloadFilter;
import org.apache.lucene.analysis.MockGraphTokenFilter;
import org.apache.lucene.analysis.MockHoleInjectingTokenFilter;
import org.apache.lucene.analysis.MockLowerCaseFilter;
import org.apache.lucene.analysis.MockRandomLookaheadTokenFilter;
import org.apache.lucene.analysis.MockSynonymFilter;
import org.apache.lucene.analysis.MockTokenFilter;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.MockVariableLengthPayloadFilter;
import org.apache.lucene.analysis.SimplePayloadFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ValidatingTokenFilter;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.TestRandomChains;
import org.apache.lucene.analysis.core.UnicodeWhitespaceTokenizer;
import org.apache.lucene.analysis.miscellaneous.PatternKeywordMarkerFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.path.ReversePathHierarchyTokenizer;
import org.apache.lucene.analysis.sinks.TeeSinkTokenFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.sr.SerbianNormalizationRegularFilter;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.StringMockResourceLoader;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.Version;

public class TestAllAnalyzersHaveFactories
extends LuceneTestCase {
    private static final Set<Class<?>> testComponents = Collections.newSetFromMap(new IdentityHashMap());
    private static final Set<Class<?>> crazyComponents;
    private static final Set<Class<?>> oddlyNamedComponents;
    private static final Set<Class<?>> tokenFiltersWithoutFactory;
    private static final ResourceLoader loader;

    public void test() throws Exception {
        List<Class<?>> analysisClasses = TestRandomChains.getClassesForPackage("org.apache.lucene.analysis");
        for (Class<?> c : analysisClasses) {
            Class<?> createdClazz2;
            TokenizerFactory instance;
            String simpleName;
            String clazzName;
            int modifiers = c.getModifiers();
            if (Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers) || c.isSynthetic() || c.isAnonymousClass() || c.isMemberClass() || c.isInterface() || testComponents.contains(c) || crazyComponents.contains(c) || oddlyNamedComponents.contains(c) || tokenFiltersWithoutFactory.contains(c) || c.isAnnotationPresent(Deprecated.class) || !Tokenizer.class.isAssignableFrom(c) && !TokenFilter.class.isAssignableFrom(c) && !CharFilter.class.isAssignableFrom(c)) continue;
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("luceneMatchVersion", Version.LATEST.toString());
            if (Tokenizer.class.isAssignableFrom(c)) {
                clazzName = c.getSimpleName();
                TestAllAnalyzersHaveFactories.assertTrue((boolean)clazzName.endsWith("Tokenizer"));
                simpleName = clazzName.substring(0, clazzName.length() - 9);
                TestAllAnalyzersHaveFactories.assertNotNull((Object)TokenizerFactory.lookupClass((String)simpleName));
                instance = null;
                try {
                    instance = TokenizerFactory.forName((String)simpleName, args);
                    TestAllAnalyzersHaveFactories.assertNotNull((Object)instance);
                    if (instance instanceof ResourceLoaderAware) {
                        ((ResourceLoaderAware)instance).inform(loader);
                    }
                    TestAllAnalyzersHaveFactories.assertSame(c, instance.create().getClass());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            if (TokenFilter.class.isAssignableFrom(c)) {
                clazzName = c.getSimpleName();
                TestAllAnalyzersHaveFactories.assertTrue((boolean)clazzName.endsWith("Filter"));
                simpleName = clazzName.substring(0, clazzName.length() - (clazzName.endsWith("TokenFilter") ? 11 : 6));
                TestAllAnalyzersHaveFactories.assertNotNull((Object)TokenFilterFactory.lookupClass((String)simpleName));
                instance = null;
                try {
                    instance = TokenFilterFactory.forName((String)simpleName, args);
                    TestAllAnalyzersHaveFactories.assertNotNull((Object)instance);
                    if (instance instanceof ResourceLoaderAware) {
                        ((ResourceLoaderAware)instance).inform(loader);
                    }
                    if (KeywordTokenizer.class == (createdClazz2 = instance.create((TokenStream)new KeywordTokenizer()).getClass())) continue;
                    TestAllAnalyzersHaveFactories.assertSame(c, createdClazz2);
                }
                catch (IllegalArgumentException createdClazz2) {}
                continue;
            }
            if (!CharFilter.class.isAssignableFrom(c)) continue;
            clazzName = c.getSimpleName();
            TestAllAnalyzersHaveFactories.assertTrue((boolean)clazzName.endsWith("CharFilter"));
            simpleName = clazzName.substring(0, clazzName.length() - 10);
            TestAllAnalyzersHaveFactories.assertNotNull((Object)CharFilterFactory.lookupClass((String)simpleName));
            instance = null;
            try {
                instance = CharFilterFactory.forName((String)simpleName, args);
                TestAllAnalyzersHaveFactories.assertNotNull((Object)instance);
                if (instance instanceof ResourceLoaderAware) {
                    ((ResourceLoaderAware)instance).inform(loader);
                }
                if (StringReader.class == (createdClazz2 = instance.create((Reader)new StringReader("")).getClass())) continue;
                TestAllAnalyzersHaveFactories.assertSame(c, createdClazz2);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    static {
        Collections.addAll(testComponents, MockTokenizer.class, MockCharFilter.class, MockFixedLengthPayloadFilter.class, MockGraphTokenFilter.class, MockHoleInjectingTokenFilter.class, MockLowerCaseFilter.class, MockRandomLookaheadTokenFilter.class, MockSynonymFilter.class, MockTokenFilter.class, MockVariableLengthPayloadFilter.class, ValidatingTokenFilter.class, CrankyTokenFilter.class, SimplePayloadFilter.class);
        crazyComponents = Collections.newSetFromMap(new IdentityHashMap());
        Collections.addAll(crazyComponents, CachingTokenFilter.class, TeeSinkTokenFilter.class);
        oddlyNamedComponents = Collections.newSetFromMap(new IdentityHashMap());
        Collections.addAll(oddlyNamedComponents, ReversePathHierarchyTokenizer.class, SnowballFilter.class, PatternKeywordMarkerFilter.class, SetKeywordMarkerFilter.class, UnicodeWhitespaceTokenizer.class, StopFilter.class, LowerCaseFilter.class);
        tokenFiltersWithoutFactory = new HashSet();
        tokenFiltersWithoutFactory.add(SerbianNormalizationRegularFilter.class);
        loader = new StringMockResourceLoader("");
    }
}

