/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseTokenizer;
import org.apache.lucene.analysis.core.PayloadSetter;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.UnicodeWhitespaceAnalyzer;
import org.apache.lucene.analysis.core.UnicodeWhitespaceTokenizer;
import org.apache.lucene.analysis.core.UpperCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;

public class TestAnalyzers
extends BaseTokenStreamTestCase {
    public void testSimple() throws Exception {
        SimpleAnalyzer a = new SimpleAnalyzer();
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"foo bar FOO BAR", (String[])new String[]{"foo", "bar", "foo", "bar"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"foo      bar .  FOO <> BAR", (String[])new String[]{"foo", "bar", "foo", "bar"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"foo.bar.FOO.BAR", (String[])new String[]{"foo", "bar", "foo", "bar"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"U.S.A.", (String[])new String[]{"u", "s", "a"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"C++", (String[])new String[]{"c"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"B2B", (String[])new String[]{"b", "b"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"2B", (String[])new String[]{"b"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"\"QUOTED\" word", (String[])new String[]{"quoted", "word"});
        TestAnalyzers.assertEquals((Object)new BytesRef((CharSequence)"\"\\\u00e03[]()! cz@"), (Object)a.normalize("dummy", "\"\\\u00c03[]()! Cz@"));
        a.close();
    }

    public void testNull() throws Exception {
        WhitespaceAnalyzer a = new WhitespaceAnalyzer();
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"foo bar FOO BAR", (String[])new String[]{"foo", "bar", "FOO", "BAR"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"foo      bar .  FOO <> BAR", (String[])new String[]{"foo", "bar", ".", "FOO", "<>", "BAR"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"foo.bar.FOO.BAR", (String[])new String[]{"foo.bar.FOO.BAR"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"U.S.A.", (String[])new String[]{"U.S.A."});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"C++", (String[])new String[]{"C++"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"B2B", (String[])new String[]{"B2B"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"2B", (String[])new String[]{"2B"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"\"QUOTED\" word", (String[])new String[]{"\"QUOTED\"", "word"});
        TestAnalyzers.assertEquals((Object)new BytesRef((CharSequence)"\"\\\u00c03[]()! Cz@"), (Object)a.normalize("dummy", "\"\\\u00c03[]()! Cz@"));
        a.close();
    }

    public void testStop() throws Exception {
        StopAnalyzer a = new StopAnalyzer();
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"foo bar FOO BAR", (String[])new String[]{"foo", "bar", "foo", "bar"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"foo a bar such FOO THESE BAR", (String[])new String[]{"foo", "bar", "foo", "bar"});
        TestAnalyzers.assertEquals((Object)new BytesRef((CharSequence)"\"\\\u00e03[]()! cz@"), (Object)a.normalize("dummy", "\"\\\u00c03[]()! Cz@"));
        TestAnalyzers.assertEquals((Object)new BytesRef((CharSequence)"the"), (Object)a.normalize("dummy", "the"));
        a.close();
    }

    void verifyPayload(TokenStream ts) throws IOException {
        boolean hasNext;
        PayloadAttribute payloadAtt = (PayloadAttribute)ts.getAttribute(PayloadAttribute.class);
        ts.reset();
        int b = 1;
        while (hasNext = ts.incrementToken()) {
            TestAnalyzers.assertEquals((long)b, (long)payloadAtt.getPayload().bytes[0]);
            b = (byte)(b + 1);
        }
    }

    public void testPayloadCopy() throws IOException {
        String s = "how now brown cow";
        Object ts = new WhitespaceTokenizer();
        ((Tokenizer)ts).setReader((Reader)new StringReader(s));
        ts = new PayloadSetter((TokenStream)ts);
        this.verifyPayload((TokenStream)ts);
        ts = new WhitespaceTokenizer();
        ((Tokenizer)ts).setReader((Reader)new StringReader(s));
        ts = new PayloadSetter((TokenStream)ts);
        this.verifyPayload((TokenStream)ts);
    }

    public void _testStandardConstants() {
        int x = 0;
        x = 1;
        x = 2;
        x = 3;
        x = 4;
        x = 5;
        x = 6;
        x = 7;
        String[] y = StandardTokenizer.TOKEN_TYPES;
    }

    public void testLowerCaseFilter() throws IOException {
        LowerCaseWhitespaceAnalyzer a = new LowerCaseWhitespaceAnalyzer();
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"AbaCaDabA", (String[])new String[]{"abacadaba"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"\ud801\udc16\ud801\udc16\ud801\udc16\ud801\udc16", (String[])new String[]{"\ud801\udc3e\ud801\udc3e\ud801\udc3e\ud801\udc3e"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"AbaCa\ud801\udc16DabA", (String[])new String[]{"abaca\ud801\udc3edaba"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"AbaC\ud801AdaBa", (String[])new String[]{"abac\ud801adaba"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"AbaC\udc16AdaBa", (String[])new String[]{"abac\udc16adaba"});
        a.close();
    }

    public void testUpperCaseFilter() throws IOException {
        UpperCaseWhitespaceAnalyzer a = new UpperCaseWhitespaceAnalyzer();
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"AbaCaDabA", (String[])new String[]{"ABACADABA"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"\ud801\udc3e\ud801\udc3e\ud801\udc3e\ud801\udc3e", (String[])new String[]{"\ud801\udc16\ud801\udc16\ud801\udc16\ud801\udc16"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"AbaCa\ud801\udc3eDabA", (String[])new String[]{"ABACA\ud801\udc16DABA"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"AbaC\ud801AdaBa", (String[])new String[]{"ABAC\ud801ADABA"});
        TestAnalyzers.assertAnalyzesTo((Analyzer)a, (String)"AbaC\udc16AdaBa", (String[])new String[]{"ABAC\udc16ADABA"});
        a.close();
    }

    public void testLowerCaseFilterLowSurrogateLeftover() throws IOException {
        WhitespaceTokenizer tokenizer = new WhitespaceTokenizer();
        tokenizer.setReader((Reader)new StringReader("BogustermBogusterm\udc16"));
        LowerCaseFilter filter = new LowerCaseFilter((TokenStream)tokenizer);
        TestAnalyzers.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"bogustermbogusterm\udc16"});
        filter.reset();
        String highSurEndingUpper = "BogustermBoguster\ud801";
        String highSurEndingLower = "bogustermboguster\ud801";
        tokenizer.setReader((Reader)new StringReader(highSurEndingUpper));
        TestAnalyzers.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{highSurEndingLower});
        TestAnalyzers.assertTrue((boolean)filter.hasAttribute(CharTermAttribute.class));
        char[] termBuffer = ((CharTermAttribute)filter.getAttribute(CharTermAttribute.class)).buffer();
        int length = highSurEndingLower.length();
        TestAnalyzers.assertEquals((long)55297L, (long)termBuffer[length - 1]);
    }

    public void testLowerCaseTokenizer() throws IOException {
        StringReader reader = new StringReader("Tokenizer \ud801\udc1ctest");
        LowerCaseTokenizer tokenizer = new LowerCaseTokenizer();
        tokenizer.setReader((Reader)reader);
        TestAnalyzers.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"tokenizer", "\ud801\udc44test"});
    }

    public void testWhitespaceTokenizer() throws IOException {
        StringReader reader = new StringReader("Tokenizer \ud801\udc1ctest");
        WhitespaceTokenizer tokenizer = new WhitespaceTokenizer();
        tokenizer.setReader((Reader)reader);
        TestAnalyzers.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"Tokenizer", "\ud801\udc1ctest"});
    }

    public void testRandomStrings() throws Exception {
        Analyzer[] analyzers;
        for (Analyzer analyzer : analyzers = new Analyzer[]{new WhitespaceAnalyzer(), new SimpleAnalyzer(), new StopAnalyzer(), new UnicodeWhitespaceAnalyzer()}) {
            TestAnalyzers.checkRandomData((Random)TestAnalyzers.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        }
        IOUtils.close((Closeable[])analyzers);
    }

    public void testRandomHugeStrings() throws Exception {
        Analyzer[] analyzers;
        for (Analyzer analyzer : analyzers = new Analyzer[]{new WhitespaceAnalyzer(), new SimpleAnalyzer(), new StopAnalyzer(), new UnicodeWhitespaceAnalyzer()}) {
            TestAnalyzers.checkRandomData((Random)TestAnalyzers.random(), (Analyzer)analyzer, (int)(100 * RANDOM_MULTIPLIER), (int)8192);
        }
        IOUtils.close((Closeable[])analyzers);
    }

    private static class UpperCaseWhitespaceAnalyzer
    extends Analyzer {
        private UpperCaseWhitespaceAnalyzer() {
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            WhitespaceTokenizer tokenizer = LuceneTestCase.random().nextBoolean() ? new WhitespaceTokenizer() : new UnicodeWhitespaceTokenizer();
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new UpperCaseFilter((TokenStream)tokenizer));
        }
    }

    private static class LowerCaseWhitespaceAnalyzer
    extends Analyzer {
        private LowerCaseWhitespaceAnalyzer() {
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            WhitespaceTokenizer tokenizer = LuceneTestCase.random().nextBoolean() ? new WhitespaceTokenizer() : new UnicodeWhitespaceTokenizer();
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new LowerCaseFilter((TokenStream)tokenizer));
        }
    }
}

