/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.CharFilter;
import org.apache.lucene.analysis.MockCharFilter;
import org.apache.lucene.analysis.MockTokenFilter;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.lucene.analysis.commongrams.CommonGramsFilter;
import org.apache.lucene.analysis.core.TestRandomChains;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.lucene.analysis.wikipedia.WikipediaTokenizer;
import org.apache.lucene.util.LuceneTestCase;

@LuceneTestCase.SuppressCodecs(value={"Direct"})
public class TestBugInSomething
extends BaseTokenStreamTestCase {
    CharFilter wrappedStream = new CharFilter(new StringReader("bogus")){

        public void mark(int readAheadLimit) {
            throw new UnsupportedOperationException("mark(int)");
        }

        public boolean markSupported() {
            throw new UnsupportedOperationException("markSupported()");
        }

        public int read() {
            throw new UnsupportedOperationException("read()");
        }

        public int read(char[] cbuf) {
            throw new UnsupportedOperationException("read(char[])");
        }

        public int read(CharBuffer target) {
            throw new UnsupportedOperationException("read(CharBuffer)");
        }

        public boolean ready() {
            throw new UnsupportedOperationException("ready()");
        }

        public void reset() {
            throw new UnsupportedOperationException("reset()");
        }

        public long skip(long n) {
            throw new UnsupportedOperationException("skip(long)");
        }

        public int correct(int currentOff) {
            throw new UnsupportedOperationException("correct(int)");
        }

        public void close() {
            throw new UnsupportedOperationException("close()");
        }

        public int read(char[] arg0, int arg1, int arg2) {
            throw new UnsupportedOperationException("read(char[], int, int)");
        }
    };

    public void test() throws Exception {
        final CharArraySet cas = new CharArraySet(3, false);
        cas.add("jjp");
        cas.add("wlmwoknt");
        cas.add("tcgyreo");
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        builder.add("mtqlpi", "");
        builder.add("mwoknt", "jjp");
        builder.add("tcgyreo", "zpfpajyws");
        final NormalizeCharMap map = builder.build();
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer t = new MockTokenizer(MockTokenFilter.ENGLISH_STOPSET, false, -65);
                CommonGramsFilter f = new CommonGramsFilter((TokenStream)t, cas);
                return new Analyzer.TokenStreamComponents((Tokenizer)t, (TokenStream)f);
            }

            protected Reader initReader(String fieldName, Reader reader) {
                reader = new MockCharFilter(reader, 0);
                reader = new MappingCharFilter(map, reader);
                reader = new TestRandomChains.CheckThatYouDidntReadAnythingReaderWrapper((Reader)reader);
                return reader;
            }
        };
        TestBugInSomething.checkAnalysisConsistency((Random)TestBugInSomething.random(), (Analyzer)a, (boolean)false, (String)"wmgddzunizdomqyj");
        a.close();
    }

    public void testWrapping() throws Exception {
        TestRandomChains.CheckThatYouDidntReadAnythingReaderWrapper cs = new TestRandomChains.CheckThatYouDidntReadAnythingReaderWrapper((Reader)this.wrappedStream);
        Exception expected = (Exception)TestBugInSomething.expectThrows(Exception.class, () -> cs.mark(1));
        TestBugInSomething.assertEquals((Object)"mark(int)", (Object)expected.getMessage());
        expected = (Exception)TestBugInSomething.expectThrows(Exception.class, () -> cs.markSupported());
        TestBugInSomething.assertEquals((Object)"markSupported()", (Object)expected.getMessage());
        expected = (Exception)TestBugInSomething.expectThrows(Exception.class, () -> cs.read());
        TestBugInSomething.assertEquals((Object)"read()", (Object)expected.getMessage());
        expected = (Exception)TestBugInSomething.expectThrows(Exception.class, () -> cs.read(new char[0]));
        TestBugInSomething.assertEquals((Object)"read(char[])", (Object)expected.getMessage());
        expected = (Exception)TestBugInSomething.expectThrows(Exception.class, () -> cs.read(CharBuffer.wrap(new char[0])));
        TestBugInSomething.assertEquals((Object)"read(CharBuffer)", (Object)expected.getMessage());
        expected = (Exception)TestBugInSomething.expectThrows(Exception.class, () -> cs.reset());
        TestBugInSomething.assertEquals((Object)"reset()", (Object)expected.getMessage());
        expected = (Exception)TestBugInSomething.expectThrows(Exception.class, () -> cs.skip(1L));
        TestBugInSomething.assertEquals((Object)"skip(long)", (Object)expected.getMessage());
        expected = (Exception)TestBugInSomething.expectThrows(Exception.class, () -> cs.correctOffset(1));
        TestBugInSomething.assertEquals((Object)"correct(int)", (Object)expected.getMessage());
        expected = (Exception)TestBugInSomething.expectThrows(Exception.class, () -> cs.close());
        TestBugInSomething.assertEquals((Object)"close()", (Object)expected.getMessage());
        expected = (Exception)TestBugInSomething.expectThrows(Exception.class, () -> cs.read(new char[0], 0, 0));
        TestBugInSomething.assertEquals((Object)"read(char[], int, int)", (Object)expected.getMessage());
    }

    @LuceneTestCase.Slow
    public void testUnicodeShinglesAndNgrams() throws Exception {
        Analyzer analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                EdgeNGramTokenizer tokenizer = new EdgeNGramTokenizer(2, 94);
                ShingleFilter stream = new ShingleFilter((TokenStream)tokenizer, 5);
                stream = new NGramTokenFilter((TokenStream)stream, 55, 83);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
            }
        };
        TestBugInSomething.checkRandomData((Random)TestBugInSomething.random(), (Analyzer)analyzer, (int)2000);
        analyzer.close();
    }

    public void testCuriousWikipediaString() throws Exception {
        final CharArraySet protWords = new CharArraySet(new HashSet<String>(Arrays.asList("rrdpafa", "pupmmlu", "xlq", "dyy", "zqrxrrck", "o", "hsrlfvcha")), false);
        final byte[] table = new byte[]{-57, 26, 1, 48, 63, -23, 55, -84, 18, 120, -97, 103, 58, 13, 84, 89, 57, -13, -63, 5, 28, 97, -54, -94, 102, -108, -5, 5, 46, 40, 43, 78, 43, -72, 36, 29, 124, -106, -22, -51, 65, 5, 31, -42, 6, -99, 97, 14, 81, -128, 74, 100, 54, -55, -25, 53, -71, -98, 44, 33, 86, 106, -42, 47, 115, -89, -18, -26, 22, -95, -43, 83, -125, 105, -104, -24, 106, -16, 126, 115, -105, 97, 65, -33, 57, 44, -1, 123, -68, 100, 13, -41, -64, -119, 0, 92, 94, -36, 53, -9, -102, -18, 90, 94, -26, 31, 71, -20};
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                WikipediaTokenizer tokenizer = new WikipediaTokenizer();
                SopTokenFilter stream = new SopTokenFilter((TokenStream)tokenizer);
                stream = new WordDelimiterFilter((TokenStream)stream, table, -50, protWords);
                stream = new SopTokenFilter((TokenStream)stream);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
            }
        };
        TestBugInSomething.checkAnalysisConsistency((Random)TestBugInSomething.random(), (Analyzer)a, (boolean)false, (String)"B\u28c3\ue0f8[ \ud800\udfc2 </p> jb");
        a.close();
    }

    static final class SopTokenFilter
    extends TokenFilter {
        SopTokenFilter(TokenStream input) {
            super(input);
        }

        public boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println(this.input.getClass().getSimpleName() + "->" + this.reflectAsString(false));
                }
                return true;
            }
            return false;
        }

        public void end() throws IOException {
            super.end();
            if (LuceneTestCase.VERBOSE) {
                System.out.println(this.input.getClass().getSimpleName() + ".end()");
            }
        }

        public void close() throws IOException {
            super.close();
            if (LuceneTestCase.VERBOSE) {
                System.out.println(this.input.getClass().getSimpleName() + ".close()");
            }
        }

        public void reset() throws IOException {
            super.reset();
            if (LuceneTestCase.VERBOSE) {
                System.out.println(this.input.getClass().getSimpleName() + ".reset()");
            }
        }
    }
}

