/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.DecimalDigitFilter;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.lucene.util.TestUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class TestDecimalDigitFilter
extends BaseTokenStreamTestCase {
    private Analyzer tokenized;
    private Analyzer keyword;
    private static SparseFixedBitSet DECIMAL_DIGIT_CODEPOINTS;

    @BeforeClass
    public static void init_DECIMAL_DIGIT_CODEPOINTS() {
        DECIMAL_DIGIT_CODEPOINTS = new SparseFixedBitSet(0x10FFFF);
        for (int codepoint = 0; codepoint < 0x10FFFF; ++codepoint) {
            if (!Character.isDigit(codepoint)) continue;
            DECIMAL_DIGIT_CODEPOINTS.set(codepoint);
        }
        assert (0 < DECIMAL_DIGIT_CODEPOINTS.cardinality());
    }

    @AfterClass
    public static void destroy_DECIMAL_DIGIT_CODEPOINTS() {
        DECIMAL_DIGIT_CODEPOINTS = null;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.tokenized = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new DecimalDigitFilter((TokenStream)tokenizer));
            }
        };
        this.keyword = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new DecimalDigitFilter((TokenStream)tokenizer));
            }
        };
    }

    public void tearDown() throws Exception {
        this.tokenized.close();
        this.keyword.close();
        super.tearDown();
    }

    public void testSimple() throws Exception {
        TestDecimalDigitFilter.checkOneTerm((Analyzer)this.tokenized, (String)"\u0661\u0662\u0663\u0664", (String)"1234");
    }

    public void testDoubleStruck() throws Exception {
        String input = "\ud835\udfd9 \ud835\udfe1 \ud835\udfe0 \ud835\udfdc";
        String expected = "1 9 8 4";
        TestDecimalDigitFilter.checkOneTerm((Analyzer)this.keyword, (String)"\ud835\udfd9 \ud835\udfe1 \ud835\udfe0 \ud835\udfdc", (String)"1 9 8 4");
        TestDecimalDigitFilter.checkOneTerm((Analyzer)this.keyword, (String)"\ud835\udfd9 \ud835\udfe1 \ud835\udfe0 \ud835\udfdc".replaceAll("\\s", ""), (String)"1 9 8 4".replaceAll("\\s", ""));
    }

    public void testRandomSequences() throws Exception {
        int numIters = TestDecimalDigitFilter.atLeast((int)5);
        for (int iter = 0; iter < numIters; ++iter) {
            int numDigits = TestDecimalDigitFilter.atLeast((int)20);
            StringBuilder expected = new StringBuilder();
            StringBuilder actual = new StringBuilder();
            for (int digitCounter = 0; digitCounter < numDigits; ++digitCounter) {
                String prefix = TestDecimalDigitFilter.random().nextBoolean() ? "" : TestUtil.randomSimpleString((Random)TestDecimalDigitFilter.random());
                expected.append(prefix);
                actual.append(prefix);
                int codepoint = TestDecimalDigitFilter.getRandomDecimalDigit(TestDecimalDigitFilter.random());
                int value = Character.getNumericValue(codepoint);
                assert (value >= 0 && value <= 9);
                expected.append(Integer.toString(value));
                actual.appendCodePoint(codepoint);
            }
            String suffix = TestDecimalDigitFilter.random().nextBoolean() ? "" : TestUtil.randomSimpleString((Random)TestDecimalDigitFilter.random());
            expected.append(suffix);
            actual.append(suffix);
            TestDecimalDigitFilter.checkOneTerm((Analyzer)this.keyword, (String)actual.toString(), (String)expected.toString());
        }
    }

    public void testRandom() throws Exception {
        int numCodePointsChecked = 0;
        int codepoint = DECIMAL_DIGIT_CODEPOINTS.nextSetBit(0);
        while (codepoint != Integer.MAX_VALUE) {
            assert (Character.isDigit(codepoint));
            String prefix = TestUtil.randomSimpleString((Random)TestDecimalDigitFilter.random());
            String suffix = TestUtil.randomSimpleString((Random)TestDecimalDigitFilter.random());
            StringBuilder expected = new StringBuilder();
            expected.append(prefix);
            int value = Character.getNumericValue(codepoint);
            assert (value >= 0 && value <= 9);
            expected.append(Integer.toString(value));
            expected.append(suffix);
            StringBuilder actual = new StringBuilder();
            actual.append(prefix);
            actual.appendCodePoint(codepoint);
            actual.append(suffix);
            TestDecimalDigitFilter.checkOneTerm((Analyzer)this.keyword, (String)actual.toString(), (String)expected.toString());
            ++numCodePointsChecked;
            codepoint = DECIMAL_DIGIT_CODEPOINTS.nextSetBit(codepoint + 1);
        }
        assert (DECIMAL_DIGIT_CODEPOINTS.cardinality() == numCodePointsChecked);
    }

    public void testEmptyTerm() throws Exception {
        TestDecimalDigitFilter.checkOneTerm((Analyzer)this.keyword, (String)"", (String)"");
    }

    public void testRandomStrings() throws Exception {
        TestDecimalDigitFilter.checkRandomData((Random)TestDecimalDigitFilter.random(), (Analyzer)this.tokenized, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public static int getRandomDecimalDigit(Random r) {
        int result;
        int aprox = TestUtil.nextInt((Random)r, (int)0, (int)(DECIMAL_DIGIT_CODEPOINTS.length() - 1));
        if (DECIMAL_DIGIT_CODEPOINTS.get(aprox)) {
            assert (Character.isDigit(aprox));
            return aprox;
        }
        int lower = DECIMAL_DIGIT_CODEPOINTS.prevSetBit(aprox);
        int higher = DECIMAL_DIGIT_CODEPOINTS.nextSetBit(aprox);
        if (lower < 0) {
            assert (higher != Integer.MAX_VALUE);
            assert (Character.isDigit(higher));
            return higher;
        }
        if (higher == Integer.MAX_VALUE) {
            assert (0 <= lower);
            assert (Character.isDigit(lower));
            return lower;
        }
        int cmp = Integer.compare(aprox - lower, higher - aprox);
        if (0 == cmp) {
            int result2;
            int n = result2 = TestDecimalDigitFilter.random().nextBoolean() ? lower : higher;
            assert (Character.isDigit(result2));
            return result2;
        }
        int n = result = cmp < 0 ? lower : higher;
        assert (Character.isDigit(result));
        return result;
    }
}

