/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestDecimalDigitFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testNormalization() throws Exception {
        StringReader reader = new StringReader("\u0661\u0662\u0663\u0664");
        MockTokenizer stream = TestDecimalDigitFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("DecimalDigit", new String[0]).create((TokenStream)stream);
        TestDecimalDigitFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"1234"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestDecimalDigitFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("DecimalDigit", "bogusArg", "bogusValue"));
        TestDecimalDigitFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

