/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockReaderWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LetterTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.Operations;

public class TestDuelingAnalyzers
extends BaseTokenStreamTestCase {
    private CharacterRunAutomaton jvmLetter;

    public void setUp() throws Exception {
        super.setUp();
        Automaton single = new Automaton();
        int initial = single.createState();
        int accept = single.createState();
        single.setAccept(accept, true);
        for (int i = 0; i <= 0x10FFFF; ++i) {
            if (!Character.isLetter(i)) continue;
            single.addTransition(initial, accept, i);
        }
        Automaton repeat = Operations.repeat((Automaton)single);
        this.jvmLetter = new CharacterRunAutomaton(repeat);
    }

    public void testLetterAscii() throws Exception {
        Random random = TestDuelingAnalyzers.random();
        MockAnalyzer left = new MockAnalyzer(random, this.jvmLetter, false);
        Analyzer right = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                LetterTokenizer tokenizer = new LetterTokenizer(BaseTokenStreamTestCase.newAttributeFactory());
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenizer);
            }
        };
        for (int i = 0; i < 1000; ++i) {
            String s = TestUtil.randomSimpleString((Random)random);
            this.assertEquals(s, left.tokenStream("foo", TestDuelingAnalyzers.newStringReader(s)), right.tokenStream("foo", TestDuelingAnalyzers.newStringReader(s)));
        }
        IOUtils.close((Closeable[])new Closeable[]{left, right});
    }

    public void testLetterAsciiHuge() throws Exception {
        Random random = TestDuelingAnalyzers.random();
        int maxLength = 8192;
        MockAnalyzer left = new MockAnalyzer(random, this.jvmLetter, false);
        left.setMaxTokenLength(255);
        Analyzer right = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                LetterTokenizer tokenizer = new LetterTokenizer(BaseTokenStreamTestCase.newAttributeFactory());
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenizer);
            }
        };
        int numIterations = TestDuelingAnalyzers.atLeast((int)50);
        for (int i = 0; i < numIterations; ++i) {
            String s = TestUtil.randomSimpleString((Random)random, (int)maxLength);
            this.assertEquals(s, left.tokenStream("foo", TestDuelingAnalyzers.newStringReader(s)), right.tokenStream("foo", TestDuelingAnalyzers.newStringReader(s)));
        }
        IOUtils.close((Closeable[])new Closeable[]{left, right});
    }

    public void testLetterHtmlish() throws Exception {
        Random random = TestDuelingAnalyzers.random();
        MockAnalyzer left = new MockAnalyzer(random, this.jvmLetter, false);
        Analyzer right = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                LetterTokenizer tokenizer = new LetterTokenizer(BaseTokenStreamTestCase.newAttributeFactory());
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenizer);
            }
        };
        for (int i = 0; i < 1000; ++i) {
            String s = TestUtil.randomHtmlishString((Random)random, (int)20);
            this.assertEquals(s, left.tokenStream("foo", TestDuelingAnalyzers.newStringReader(s)), right.tokenStream("foo", TestDuelingAnalyzers.newStringReader(s)));
        }
        IOUtils.close((Closeable[])new Closeable[]{left, right});
    }

    public void testLetterHtmlishHuge() throws Exception {
        Random random = TestDuelingAnalyzers.random();
        int maxLength = 1024;
        MockAnalyzer left = new MockAnalyzer(random, this.jvmLetter, false);
        left.setMaxTokenLength(255);
        Analyzer right = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                LetterTokenizer tokenizer = new LetterTokenizer(BaseTokenStreamTestCase.newAttributeFactory());
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenizer);
            }
        };
        int numIterations = TestDuelingAnalyzers.atLeast((int)50);
        for (int i = 0; i < numIterations; ++i) {
            String s = TestUtil.randomHtmlishString((Random)random, (int)maxLength);
            this.assertEquals(s, left.tokenStream("foo", TestDuelingAnalyzers.newStringReader(s)), right.tokenStream("foo", TestDuelingAnalyzers.newStringReader(s)));
        }
        IOUtils.close((Closeable[])new Closeable[]{left, right});
    }

    public void testLetterUnicode() throws Exception {
        Random random = TestDuelingAnalyzers.random();
        MockAnalyzer left = new MockAnalyzer(TestDuelingAnalyzers.random(), this.jvmLetter, false);
        Analyzer right = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                LetterTokenizer tokenizer = new LetterTokenizer(BaseTokenStreamTestCase.newAttributeFactory());
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenizer);
            }
        };
        for (int i = 0; i < 1000; ++i) {
            String s = TestUtil.randomUnicodeString((Random)random);
            this.assertEquals(s, left.tokenStream("foo", TestDuelingAnalyzers.newStringReader(s)), right.tokenStream("foo", TestDuelingAnalyzers.newStringReader(s)));
        }
        IOUtils.close((Closeable[])new Closeable[]{left, right});
    }

    public void testLetterUnicodeHuge() throws Exception {
        Random random = TestDuelingAnalyzers.random();
        int maxLength = 4300;
        MockAnalyzer left = new MockAnalyzer(random, this.jvmLetter, false);
        left.setMaxTokenLength(255);
        Analyzer right = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                LetterTokenizer tokenizer = new LetterTokenizer(BaseTokenStreamTestCase.newAttributeFactory());
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenizer);
            }
        };
        int numIterations = TestDuelingAnalyzers.atLeast((int)50);
        for (int i = 0; i < numIterations; ++i) {
            String s = TestUtil.randomUnicodeString((Random)random, (int)maxLength);
            this.assertEquals(s, left.tokenStream("foo", TestDuelingAnalyzers.newStringReader(s)), right.tokenStream("foo", TestDuelingAnalyzers.newStringReader(s)));
        }
        IOUtils.close((Closeable[])new Closeable[]{left, right});
    }

    public void assertEquals(String s, TokenStream left, TokenStream right) throws Exception {
        left.reset();
        right.reset();
        CharTermAttribute leftTerm = (CharTermAttribute)left.addAttribute(CharTermAttribute.class);
        CharTermAttribute rightTerm = (CharTermAttribute)right.addAttribute(CharTermAttribute.class);
        OffsetAttribute leftOffset = (OffsetAttribute)left.addAttribute(OffsetAttribute.class);
        OffsetAttribute rightOffset = (OffsetAttribute)right.addAttribute(OffsetAttribute.class);
        PositionIncrementAttribute leftPos = (PositionIncrementAttribute)left.addAttribute(PositionIncrementAttribute.class);
        PositionIncrementAttribute rightPos = (PositionIncrementAttribute)right.addAttribute(PositionIncrementAttribute.class);
        while (left.incrementToken()) {
            TestDuelingAnalyzers.assertTrue((String)("wrong number of tokens for input: " + s), (boolean)right.incrementToken());
            TestDuelingAnalyzers.assertEquals((String)("wrong term text for input: " + s), (Object)leftTerm.toString(), (Object)rightTerm.toString());
            TestDuelingAnalyzers.assertEquals((String)("wrong position for input: " + s), (long)leftPos.getPositionIncrement(), (long)rightPos.getPositionIncrement());
            TestDuelingAnalyzers.assertEquals((String)("wrong start offset for input: " + s), (long)leftOffset.startOffset(), (long)rightOffset.startOffset());
            TestDuelingAnalyzers.assertEquals((String)("wrong end offset for input: " + s), (long)leftOffset.endOffset(), (long)rightOffset.endOffset());
        }
        TestDuelingAnalyzers.assertFalse((String)("wrong number of tokens for input: " + s), (boolean)right.incrementToken());
        left.end();
        right.end();
        TestDuelingAnalyzers.assertEquals((String)("wrong final offset for input: " + s), (long)leftOffset.endOffset(), (long)rightOffset.endOffset());
        left.close();
        right.close();
    }

    private static Reader newStringReader(String s) {
        Random random = TestDuelingAnalyzers.random();
        StringReader r = new StringReader(s);
        if (random.nextBoolean()) {
            r = new MockReaderWrapper(random, (Reader)r);
        }
        return r;
    }
}

