/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.MultiTermAwareComponent;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.StringMockResourceLoader;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.Version;

public class TestFactories
extends BaseTokenStreamTestCase {
    private TokenizerFactory assertingTokenizer = new TokenizerFactory(new HashMap()){

        public MockTokenizer create(AttributeFactory factory) {
            return new MockTokenizer(factory);
        }
    };

    public void test() throws IOException {
        for (String tokenizer : TokenizerFactory.availableTokenizers()) {
            this.doTestTokenizer(tokenizer);
        }
        for (String tokenFilter : TokenFilterFactory.availableTokenFilters()) {
            this.doTestTokenFilter(tokenFilter);
        }
        for (String charFilter : CharFilterFactory.availableCharFilters()) {
            this.doTestCharFilter(charFilter);
        }
    }

    private void doTestTokenizer(String tokenizer) throws IOException {
        Class factoryClazz = TokenizerFactory.lookupClass((String)tokenizer);
        TokenizerFactory factory = (TokenizerFactory)this.initialize(factoryClazz);
        if (factory != null) {
            if (factory instanceof MultiTermAwareComponent) {
                AbstractAnalysisFactory mtc = ((MultiTermAwareComponent)factory).getMultiTermComponent();
                TestFactories.assertNotNull((Object)mtc);
                TestFactories.assertFalse((boolean)(mtc instanceof CharFilterFactory));
            }
            FactoryAnalyzer a = new FactoryAnalyzer(factory, null, null);
            TestFactories.checkRandomData((Random)TestFactories.random(), (Analyzer)a, (int)20, (int)20, (boolean)false, (boolean)false);
            a.close();
        }
    }

    private void doTestTokenFilter(String tokenfilter) throws IOException {
        Class factoryClazz = TokenFilterFactory.lookupClass((String)tokenfilter);
        TokenFilterFactory factory = (TokenFilterFactory)this.initialize(factoryClazz);
        if (factory != null) {
            if (factory instanceof MultiTermAwareComponent) {
                AbstractAnalysisFactory mtc = ((MultiTermAwareComponent)factory).getMultiTermComponent();
                TestFactories.assertNotNull((Object)mtc);
                TestFactories.assertTrue((boolean)(mtc instanceof TokenFilterFactory));
            }
            FactoryAnalyzer a = new FactoryAnalyzer(this.assertingTokenizer, factory, null);
            TestFactories.checkRandomData((Random)TestFactories.random(), (Analyzer)a, (int)20, (int)20, (boolean)false, (boolean)false);
            a.close();
        }
    }

    private void doTestCharFilter(String charfilter) throws IOException {
        Class factoryClazz = CharFilterFactory.lookupClass((String)charfilter);
        CharFilterFactory factory = (CharFilterFactory)this.initialize(factoryClazz);
        if (factory != null) {
            if (factory instanceof MultiTermAwareComponent) {
                AbstractAnalysisFactory mtc = ((MultiTermAwareComponent)factory).getMultiTermComponent();
                TestFactories.assertNotNull((Object)mtc);
                TestFactories.assertTrue((boolean)(mtc instanceof CharFilterFactory));
            }
            FactoryAnalyzer a = new FactoryAnalyzer(this.assertingTokenizer, null, factory);
            TestFactories.checkRandomData((Random)TestFactories.random(), (Analyzer)a, (int)20, (int)20, (boolean)false, (boolean)false);
            a.close();
        }
    }

    private AbstractAnalysisFactory initialize(Class<? extends AbstractAnalysisFactory> factoryClazz) throws IOException {
        AbstractAnalysisFactory factory;
        block9: {
            Constructor<? extends AbstractAnalysisFactory> ctor;
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("luceneMatchVersion", Version.LATEST.toString());
            try {
                ctor = factoryClazz.getConstructor(Map.class);
            }
            catch (Exception e) {
                throw new RuntimeException("factory '" + factoryClazz + "' does not have a proper ctor!");
            }
            factory = null;
            try {
                factory = ctor.newInstance(args);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                if (!(e.getCause() instanceof IllegalArgumentException)) break block9;
                return null;
            }
        }
        if (factory instanceof ResourceLoaderAware) {
            try {
                ((ResourceLoaderAware)factory).inform((ResourceLoader)new StringMockResourceLoader(""));
            }
            catch (IOException iOException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return factory;
    }

    private static class FactoryAnalyzer
    extends Analyzer {
        final TokenizerFactory tokenizer;
        final CharFilterFactory charFilter;
        final TokenFilterFactory tokenfilter;

        FactoryAnalyzer(TokenizerFactory tokenizer, TokenFilterFactory tokenfilter, CharFilterFactory charFilter) {
            assert (tokenizer != null);
            this.tokenizer = tokenizer;
            this.charFilter = charFilter;
            this.tokenfilter = tokenfilter;
        }

        protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
            Tokenizer tf = this.tokenizer.create(BaseTokenStreamTestCase.newAttributeFactory());
            if (this.tokenfilter != null) {
                return new Analyzer.TokenStreamComponents(tf, this.tokenfilter.create((TokenStream)tf));
            }
            return new Analyzer.TokenStreamComponents(tf);
        }

        protected Reader initReader(String fieldName, Reader reader) {
            if (this.charFilter != null) {
                return this.charFilter.create(reader);
            }
            return reader;
        }
    }
}

