/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CannedTokenStream;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.FlattenGraphFilter;

public class TestFlattenGraphFilter
extends BaseTokenStreamTestCase {
    private static Token token(String term, int posInc, int posLength, int startOffset, int endOffset) {
        Token t = new Token((CharSequence)term, startOffset, endOffset);
        t.setPositionIncrement(posInc);
        t.setPositionLength(posLength);
        return t;
    }

    public void testSimpleMock() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.SIMPLE, true);
                FlattenGraphFilter ts = new FlattenGraphFilter((TokenStream)tokenizer);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)ts);
            }
        };
        TestFlattenGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"wtf happened", (String[])new String[]{"wtf", "happened"}, (int[])new int[]{0, 4}, (int[])new int[]{3, 12}, null, (int[])new int[]{1, 1}, (int[])new int[]{1, 1}, (boolean)true);
    }

    public void testAlreadyFlatten() throws Exception {
        CannedTokenStream in = new CannedTokenStream(0, 12, new Token[]{TestFlattenGraphFilter.token("wtf", 1, 1, 0, 3), TestFlattenGraphFilter.token("what", 0, 1, 0, 3), TestFlattenGraphFilter.token("wow", 0, 1, 0, 3), TestFlattenGraphFilter.token("the", 1, 1, 0, 3), TestFlattenGraphFilter.token("that's", 0, 1, 0, 3), TestFlattenGraphFilter.token("fudge", 1, 1, 0, 3), TestFlattenGraphFilter.token("funny", 0, 1, 0, 3), TestFlattenGraphFilter.token("happened", 1, 1, 4, 12)});
        FlattenGraphFilter out = new FlattenGraphFilter((TokenStream)in);
        TestFlattenGraphFilter.assertTokenStreamContents((TokenStream)out, (String[])new String[]{"wtf", "what", "wow", "the", "that's", "fudge", "funny", "happened"}, (int[])new int[]{0, 0, 0, 0, 0, 0, 0, 4}, (int[])new int[]{3, 3, 3, 3, 3, 3, 3, 12}, (int[])new int[]{1, 0, 0, 1, 0, 1, 0, 1}, (int[])new int[]{1, 1, 1, 1, 1, 1, 1, 1}, (Integer)12);
    }

    public void testWTF1() throws Exception {
        CannedTokenStream in = new CannedTokenStream(0, 12, new Token[]{TestFlattenGraphFilter.token("wtf", 1, 5, 0, 3), TestFlattenGraphFilter.token("what", 0, 1, 0, 3), TestFlattenGraphFilter.token("wow", 0, 3, 0, 3), TestFlattenGraphFilter.token("the", 1, 1, 0, 3), TestFlattenGraphFilter.token("fudge", 1, 3, 0, 3), TestFlattenGraphFilter.token("that's", 1, 1, 0, 3), TestFlattenGraphFilter.token("funny", 1, 1, 0, 3), TestFlattenGraphFilter.token("happened", 1, 1, 4, 12)});
        FlattenGraphFilter out = new FlattenGraphFilter((TokenStream)in);
        TestFlattenGraphFilter.assertTokenStreamContents((TokenStream)out, (String[])new String[]{"wtf", "what", "wow", "the", "that's", "fudge", "funny", "happened"}, (int[])new int[]{0, 0, 0, 0, 0, 0, 0, 4}, (int[])new int[]{3, 3, 3, 3, 3, 3, 3, 12}, (int[])new int[]{1, 0, 0, 1, 0, 1, 0, 1}, (int[])new int[]{3, 1, 1, 1, 1, 1, 1, 1}, (Integer)12);
    }

    public void testWTF2() throws Exception {
        CannedTokenStream in = new CannedTokenStream(0, 12, new Token[]{TestFlattenGraphFilter.token("what", 1, 1, 0, 3), TestFlattenGraphFilter.token("wow", 0, 3, 0, 3), TestFlattenGraphFilter.token("wtf", 0, 5, 0, 3), TestFlattenGraphFilter.token("the", 1, 1, 0, 3), TestFlattenGraphFilter.token("fudge", 1, 3, 0, 3), TestFlattenGraphFilter.token("that's", 1, 1, 0, 3), TestFlattenGraphFilter.token("funny", 1, 1, 0, 3), TestFlattenGraphFilter.token("happened", 1, 1, 4, 12)});
        FlattenGraphFilter out = new FlattenGraphFilter((TokenStream)in);
        TestFlattenGraphFilter.assertTokenStreamContents((TokenStream)out, (String[])new String[]{"what", "wow", "wtf", "the", "that's", "fudge", "funny", "happened"}, (int[])new int[]{0, 0, 0, 0, 0, 0, 0, 4}, (int[])new int[]{3, 3, 3, 3, 3, 3, 3, 12}, (int[])new int[]{1, 0, 0, 1, 0, 1, 0, 1}, (int[])new int[]{1, 1, 3, 1, 1, 1, 1, 1}, (Integer)12);
    }

    public void testNonGreedySynonyms() throws Exception {
        CannedTokenStream in = new CannedTokenStream(0, 20, new Token[]{TestFlattenGraphFilter.token("wizard", 1, 1, 0, 6), TestFlattenGraphFilter.token("wizard_of_oz", 0, 3, 0, 12), TestFlattenGraphFilter.token("of", 1, 1, 7, 9), TestFlattenGraphFilter.token("oz", 1, 1, 10, 12), TestFlattenGraphFilter.token("oz_screams", 0, 2, 10, 20), TestFlattenGraphFilter.token("screams", 1, 1, 13, 20)});
        FlattenGraphFilter out = new FlattenGraphFilter((TokenStream)in);
        TestFlattenGraphFilter.assertTokenStreamContents((TokenStream)out, (String[])new String[]{"wizard", "wizard_of_oz", "of", "oz", "oz_screams", "screams"}, (int[])new int[]{0, 0, 7, 10, 10, 13}, (int[])new int[]{6, 12, 9, 12, 20, 20}, (int[])new int[]{1, 0, 1, 1, 0, 1}, (int[])new int[]{1, 3, 1, 1, 2, 1}, (Integer)20);
    }

    public void testNonGraph() throws Exception {
        CannedTokenStream in = new CannedTokenStream(0, 22, new Token[]{TestFlattenGraphFilter.token("hello", 1, 1, 0, 5), TestFlattenGraphFilter.token("pseudo", 1, 1, 6, 12), TestFlattenGraphFilter.token("world", 1, 1, 13, 18), TestFlattenGraphFilter.token("fun", 1, 1, 19, 22)});
        FlattenGraphFilter out = new FlattenGraphFilter((TokenStream)in);
        TestFlattenGraphFilter.assertTokenStreamContents((TokenStream)out, (String[])new String[]{"hello", "pseudo", "world", "fun"}, (int[])new int[]{0, 6, 13, 19}, (int[])new int[]{5, 12, 18, 22}, (int[])new int[]{1, 1, 1, 1}, (int[])new int[]{1, 1, 1, 1}, (Integer)22);
    }

    public void testSimpleHole() throws Exception {
        CannedTokenStream in = new CannedTokenStream(0, 13, new Token[]{TestFlattenGraphFilter.token("hello", 1, 1, 0, 5), TestFlattenGraphFilter.token("hole", 2, 1, 6, 10), TestFlattenGraphFilter.token("fun", 1, 1, 11, 13)});
        FlattenGraphFilter out = new FlattenGraphFilter((TokenStream)in);
        TestFlattenGraphFilter.assertTokenStreamContents((TokenStream)out, (String[])new String[]{"hello", "hole", "fun"}, (int[])new int[]{0, 6, 11}, (int[])new int[]{5, 10, 13}, (int[])new int[]{1, 2, 1}, (int[])new int[]{1, 1, 1}, (Integer)13);
    }

    public void testHoleUnderSyn() throws Exception {
        CannedTokenStream in = new CannedTokenStream(0, 12, new Token[]{TestFlattenGraphFilter.token("wizard", 1, 1, 0, 6), TestFlattenGraphFilter.token("woz", 0, 3, 0, 12), TestFlattenGraphFilter.token("oz", 2, 1, 10, 12)});
        FlattenGraphFilter out = new FlattenGraphFilter((TokenStream)in);
        TestFlattenGraphFilter.assertTokenStreamContents((TokenStream)out, (String[])new String[]{"wizard", "woz", "oz"}, (int[])new int[]{0, 0, 10}, (int[])new int[]{6, 12, 12}, (int[])new int[]{1, 0, 2}, (int[])new int[]{1, 3, 1}, (Integer)12);
    }

    public void testStrangelyNumberedNodes() throws Exception {
        CannedTokenStream in = new CannedTokenStream(0, 27, new Token[]{TestFlattenGraphFilter.token("dog", 1, 3, 0, 5), TestFlattenGraphFilter.token("puppy", 0, 3, 0, 5), TestFlattenGraphFilter.token("flies", 3, 1, 6, 11)});
        FlattenGraphFilter out = new FlattenGraphFilter((TokenStream)in);
        TestFlattenGraphFilter.assertTokenStreamContents((TokenStream)out, (String[])new String[]{"dog", "puppy", "flies"}, (int[])new int[]{0, 0, 6}, (int[])new int[]{5, 5, 11}, (int[])new int[]{1, 0, 1}, (int[])new int[]{1, 1, 1}, (Integer)27);
    }

    public void testTwoLongParallelPaths() throws Exception {
        CannedTokenStream in = new CannedTokenStream(0, 11, new Token[]{TestFlattenGraphFilter.token("a", 1, 1, 0, 1), TestFlattenGraphFilter.token("b", 0, 2, 0, 1), TestFlattenGraphFilter.token("a", 1, 2, 2, 3), TestFlattenGraphFilter.token("b", 1, 2, 2, 3), TestFlattenGraphFilter.token("a", 1, 2, 4, 5), TestFlattenGraphFilter.token("b", 1, 2, 4, 5), TestFlattenGraphFilter.token("a", 1, 2, 6, 7), TestFlattenGraphFilter.token("b", 1, 2, 6, 7), TestFlattenGraphFilter.token("a", 1, 2, 8, 9), TestFlattenGraphFilter.token("b", 1, 2, 8, 9), TestFlattenGraphFilter.token("a", 1, 2, 10, 11), TestFlattenGraphFilter.token("b", 1, 2, 10, 11)});
        FlattenGraphFilter out = new FlattenGraphFilter((TokenStream)in);
        TestFlattenGraphFilter.assertTokenStreamContents((TokenStream)out, (String[])new String[]{"a", "b", "a", "b", "a", "b", "a", "b", "a", "b", "a", "b"}, (int[])new int[]{0, 0, 2, 2, 4, 4, 6, 6, 8, 8, 10, 10}, (int[])new int[]{1, 1, 3, 3, 5, 5, 7, 7, 9, 9, 11, 11}, (int[])new int[]{1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0}, (int[])new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, (Integer)11);
    }
}

