/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.TestUtil;

public class TestKeywordAnalyzer
extends BaseTokenStreamTestCase {
    private Directory directory;
    private IndexReader reader;
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.directory = TestKeywordAnalyzer.newDirectory();
        this.analyzer = new SimpleAnalyzer();
        IndexWriter writer = new IndexWriter(this.directory, new IndexWriterConfig(this.analyzer));
        Document doc = new Document();
        doc.add((IndexableField)new StringField("partnum", "Q36", Field.Store.YES));
        doc.add((IndexableField)new TextField("description", "Illidium Space Modulator", Field.Store.YES));
        writer.addDocument((Iterable)doc);
        writer.close();
        this.reader = DirectoryReader.open((Directory)this.directory);
    }

    public void tearDown() throws Exception {
        IOUtils.close((Closeable[])new Closeable[]{this.analyzer, this.reader, this.directory});
        super.tearDown();
    }

    public void testMutipleDocument() throws Exception {
        RAMDirectory dir = new RAMDirectory();
        KeywordAnalyzer analyzer = new KeywordAnalyzer();
        IndexWriter writer = new IndexWriter((Directory)dir, new IndexWriterConfig((Analyzer)analyzer));
        Document doc = new Document();
        doc.add((IndexableField)new TextField("partnum", "Q36", Field.Store.YES));
        writer.addDocument((Iterable)doc);
        doc = new Document();
        doc.add((IndexableField)new TextField("partnum", "Q37", Field.Store.YES));
        writer.addDocument((Iterable)doc);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        PostingsEnum td = TestUtil.docs((Random)TestKeywordAnalyzer.random(), (IndexReader)reader, (String)"partnum", (BytesRef)new BytesRef((CharSequence)"Q36"), null, (int)0);
        TestKeywordAnalyzer.assertTrue((td.nextDoc() != Integer.MAX_VALUE ? 1 : 0) != 0);
        td = TestUtil.docs((Random)TestKeywordAnalyzer.random(), (IndexReader)reader, (String)"partnum", (BytesRef)new BytesRef((CharSequence)"Q37"), null, (int)0);
        TestKeywordAnalyzer.assertTrue((td.nextDoc() != Integer.MAX_VALUE ? 1 : 0) != 0);
        analyzer.close();
    }

    public void testOffsets() throws Exception {
        try (KeywordAnalyzer analyzer = new KeywordAnalyzer();
             TokenStream stream = analyzer.tokenStream("field", (Reader)new StringReader("abcd"));){
            OffsetAttribute offsetAtt = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
            stream.reset();
            TestKeywordAnalyzer.assertTrue((boolean)stream.incrementToken());
            TestKeywordAnalyzer.assertEquals((long)0L, (long)offsetAtt.startOffset());
            TestKeywordAnalyzer.assertEquals((long)4L, (long)offsetAtt.endOffset());
            TestKeywordAnalyzer.assertFalse((boolean)stream.incrementToken());
            stream.end();
        }
    }

    public void testRandomStrings() throws Exception {
        KeywordAnalyzer analyzer = new KeywordAnalyzer();
        TestKeywordAnalyzer.checkRandomData((Random)TestKeywordAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

