/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.CharArrayMap;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.CharFilter;
import org.apache.lucene.analysis.CrankyTokenFilter;
import org.apache.lucene.analysis.MockGraphTokenFilter;
import org.apache.lucene.analysis.MockRandomLookaheadTokenFilter;
import org.apache.lucene.analysis.MockTokenFilter;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ValidatingTokenFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.lucene.analysis.commongrams.CommonGramsFilter;
import org.apache.lucene.analysis.commongrams.CommonGramsQueryFilter;
import org.apache.lucene.analysis.compound.HyphenationCompoundWordTokenFilter;
import org.apache.lucene.analysis.compound.TestCompoundWordTokenFilter;
import org.apache.lucene.analysis.compound.hyphenation.HyphenationTree;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.TestHunspellStemFilter;
import org.apache.lucene.analysis.miscellaneous.HyphenatedWordsFilter;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountFilter;
import org.apache.lucene.analysis.miscellaneous.LimitTokenOffsetFilter;
import org.apache.lucene.analysis.miscellaneous.LimitTokenPositionFilter;
import org.apache.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterGraphFilter;
import org.apache.lucene.analysis.path.PathHierarchyTokenizer;
import org.apache.lucene.analysis.path.ReversePathHierarchyTokenizer;
import org.apache.lucene.analysis.payloads.IdentityEncoder;
import org.apache.lucene.analysis.snowball.TestSnowball;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.wikipedia.WikipediaTokenizer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.Rethrow;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.AutomatonTestUtil;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.tartarus.snowball.SnowballProgram;
import org.xml.sax.InputSource;

public class TestRandomChains
extends BaseTokenStreamTestCase {
    static List<Constructor<? extends Tokenizer>> tokenizers;
    static List<Constructor<? extends TokenFilter>> tokenfilters;
    static List<Constructor<? extends CharFilter>> charfilters;
    private static final Predicate<Object[]> ALWAYS;
    private static final Map<Constructor<?>, Predicate<Object[]>> brokenConstructors;
    private static final Map<Constructor<?>, Predicate<Object[]>> brokenOffsetsConstructors;
    private static final Map<Class<?>, Function<Random, Object>> argProducers;
    static final Set<Class<?>> allowedTokenizerArgs;
    static final Set<Class<?>> allowedTokenFilterArgs;
    static final Set<Class<?>> allowedCharFilterArgs;

    @BeforeClass
    public static void beforeClass() throws Exception {
        List<Class<?>> analysisClasses = TestRandomChains.getClassesForPackage("org.apache.lucene.analysis");
        tokenizers = new ArrayList<Constructor<? extends Tokenizer>>();
        tokenfilters = new ArrayList<Constructor<? extends TokenFilter>>();
        charfilters = new ArrayList<Constructor<? extends CharFilter>>();
        for (Class<?> c : analysisClasses) {
            int modifiers = c.getModifiers();
            if (Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers) || c.isSynthetic() || c.isAnonymousClass() || c.isMemberClass() || c.isInterface() || c.isAnnotationPresent(Deprecated.class) || !Tokenizer.class.isAssignableFrom(c) && !TokenFilter.class.isAssignableFrom(c) && !CharFilter.class.isAssignableFrom(c)) continue;
            for (Constructor<?> ctor : c.getConstructors()) {
                if (ctor.isSynthetic() || ctor.isAnnotationPresent(Deprecated.class) || brokenConstructors.get(ctor) == ALWAYS) continue;
                if (Tokenizer.class.isAssignableFrom(c)) {
                    TestRandomChains.assertTrue((String)(ctor.toGenericString() + " has unsupported parameter types"), (boolean)allowedTokenizerArgs.containsAll(Arrays.asList(ctor.getParameterTypes())));
                    tokenizers.add(TestRandomChains.castConstructor(Tokenizer.class, ctor));
                    continue;
                }
                if (TokenFilter.class.isAssignableFrom(c)) {
                    TestRandomChains.assertTrue((String)(ctor.toGenericString() + " has unsupported parameter types"), (boolean)allowedTokenFilterArgs.containsAll(Arrays.asList(ctor.getParameterTypes())));
                    tokenfilters.add(TestRandomChains.castConstructor(TokenFilter.class, ctor));
                    continue;
                }
                if (CharFilter.class.isAssignableFrom(c)) {
                    TestRandomChains.assertTrue((String)(ctor.toGenericString() + " has unsupported parameter types"), (boolean)allowedCharFilterArgs.containsAll(Arrays.asList(ctor.getParameterTypes())));
                    charfilters.add(TestRandomChains.castConstructor(CharFilter.class, ctor));
                    continue;
                }
                TestRandomChains.fail((String)"Cannot get here");
            }
        }
        Comparator ctorComp = (arg0, arg1) -> arg0.toGenericString().compareTo(arg1.toGenericString());
        Collections.sort(tokenizers, ctorComp);
        Collections.sort(tokenfilters, ctorComp);
        Collections.sort(charfilters, ctorComp);
        if (VERBOSE) {
            System.out.println("tokenizers = " + tokenizers);
            System.out.println("tokenfilters = " + tokenfilters);
            System.out.println("charfilters = " + charfilters);
        }
    }

    @AfterClass
    public static void afterClass() {
        tokenizers = null;
        tokenfilters = null;
        charfilters = null;
    }

    private static <T> Constructor<T> castConstructor(Class<T> instanceClazz, Constructor<?> ctor) {
        return ctor;
    }

    public static List<Class<?>> getClassesForPackage(String pckgname) throws Exception {
        ArrayList classes = new ArrayList();
        TestRandomChains.collectClassesForPackage(pckgname, classes);
        TestRandomChains.assertFalse((String)("No classes found in package '" + pckgname + "'; maybe your test classes are packaged as JAR file?"), (boolean)classes.isEmpty());
        return classes;
    }

    private static void collectClassesForPackage(String pckgname, List<Class<?>> classes) throws Exception {
        ClassLoader cld = TestRandomChains.class.getClassLoader();
        String path = pckgname.replace('.', '/');
        Enumeration<URL> resources = cld.getResources(path);
        while (resources.hasMoreElements()) {
            Path directory;
            URI uri = resources.nextElement().toURI();
            if (!"file".equalsIgnoreCase(uri.getScheme()) || !Files.exists(directory = Paths.get(uri), new LinkOption[0])) continue;
            DirectoryStream<Path> stream = Files.newDirectoryStream(directory);
            try {
                for (Path file : stream) {
                    String clazzName;
                    String fname;
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        String subPackage = pckgname + "." + file.getFileName().toString();
                        TestRandomChains.collectClassesForPackage(subPackage, classes);
                    }
                    if (!(fname = file.getFileName().toString()).endsWith(".class") || (clazzName = fname.substring(0, fname.length() - 6)).endsWith("Test") || clazzName.startsWith("Test")) continue;
                    classes.add(Class.forName(pckgname + '.' + clazzName, false, cld));
                }
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
    }

    static <T> T newRandomArg(Random random, Class<T> paramType) {
        Function<Random, Object> producer = argProducers.get(paramType);
        TestRandomChains.assertNotNull((String)("No producer for arguments of type " + paramType.getName() + " found"), producer);
        return (T)producer.apply(random);
    }

    static Object[] newTokenizerArgs(Random random, Class<?>[] paramTypes) {
        Object[] args = new Object[paramTypes.length];
        for (int i = 0; i < args.length; ++i) {
            Class<?> paramType = paramTypes[i];
            args[i] = paramType == AttributeSource.class ? null : TestRandomChains.newRandomArg(random, paramType);
        }
        return args;
    }

    static Object[] newCharFilterArgs(Random random, Reader reader, Class<?>[] paramTypes) {
        Object[] args = new Object[paramTypes.length];
        for (int i = 0; i < args.length; ++i) {
            Class<?> paramType = paramTypes[i];
            args[i] = paramType == Reader.class ? reader : TestRandomChains.newRandomArg(random, paramType);
        }
        return args;
    }

    static Object[] newFilterArgs(Random random, TokenStream stream, Class<?>[] paramTypes) {
        Object[] args = new Object[paramTypes.length];
        for (int i = 0; i < args.length; ++i) {
            Class<?> paramType = paramTypes[i];
            args[i] = paramType == TokenStream.class ? stream : (paramType == CommonGramsFilter.class ? new CommonGramsFilter(stream, TestRandomChains.newRandomArg(random, CharArraySet.class)) : TestRandomChains.newRandomArg(random, paramType));
        }
        return args;
    }

    public void testRandomChains() throws Throwable {
        int numIterations = TEST_NIGHTLY ? TestRandomChains.atLeast((int)20) : 3;
        Random random = TestRandomChains.random();
        for (int i = 0; i < numIterations; ++i) {
            try (MockRandomAnalyzer a = new MockRandomAnalyzer(random.nextLong());){
                if (VERBOSE) {
                    System.out.println("Creating random analyzer:" + (Object)((Object)a));
                }
                try {
                    this.checkNormalize(a);
                    TestRandomChains.checkRandomData((Random)random, (Analyzer)a, (int)(500 * RANDOM_MULTIPLIER), (int)20, (boolean)false, (boolean)false);
                    continue;
                }
                catch (Throwable e) {
                    System.err.println("Exception from random analyzer: " + (Object)((Object)a));
                    throw e;
                }
            }
        }
    }

    public void checkNormalize(Analyzer a) {
        String s = "([0-9]+)?*";
        TestRandomChains.assertEquals((Object)s, (Object)a.normalize("dummy", s).utf8ToString());
    }

    public void testRandomChainsWithLargeStrings() throws Throwable {
        int numIterations = TEST_NIGHTLY ? TestRandomChains.atLeast((int)20) : 3;
        Random random = TestRandomChains.random();
        for (int i = 0; i < numIterations; ++i) {
            try (MockRandomAnalyzer a = new MockRandomAnalyzer(random.nextLong());){
                if (VERBOSE) {
                    System.out.println("Creating random analyzer:" + (Object)((Object)a));
                }
                try {
                    TestRandomChains.checkRandomData((Random)random, (Analyzer)a, (int)(50 * RANDOM_MULTIPLIER), (int)80, (boolean)false, (boolean)false);
                    continue;
                }
                catch (Throwable e) {
                    System.err.println("Exception from random analyzer: " + (Object)((Object)a));
                    throw e;
                }
            }
        }
    }

    static {
        ALWAYS = objects -> true;
        brokenConstructors = new HashMap();
        try {
            brokenConstructors.put(LimitTokenCountFilter.class.getConstructor(TokenStream.class, Integer.TYPE), ALWAYS);
            brokenConstructors.put(LimitTokenCountFilter.class.getConstructor(TokenStream.class, Integer.TYPE, Boolean.TYPE), args -> {
                assert (((Object[])args).length == 3);
                return (Boolean)args[2] == false;
            });
            brokenConstructors.put(LimitTokenOffsetFilter.class.getConstructor(TokenStream.class, Integer.TYPE), ALWAYS);
            brokenConstructors.put(LimitTokenOffsetFilter.class.getConstructor(TokenStream.class, Integer.TYPE, Boolean.TYPE), args -> {
                assert (((Object[])args).length == 3);
                return (Boolean)args[2] == false;
            });
            brokenConstructors.put(LimitTokenPositionFilter.class.getConstructor(TokenStream.class, Integer.TYPE), ALWAYS);
            brokenConstructors.put(LimitTokenPositionFilter.class.getConstructor(TokenStream.class, Integer.TYPE, Boolean.TYPE), args -> {
                assert (((Object[])args).length == 3);
                return (Boolean)args[2] == false;
            });
            for (Class c : Arrays.asList(CachingTokenFilter.class, CrankyTokenFilter.class, ValidatingTokenFilter.class, WordDelimiterFilter.class, WordDelimiterGraphFilter.class, StopFilter.class, LowerCaseFilter.class)) {
                for (Constructor<?> ctor : c.getConstructors()) {
                    brokenConstructors.put(ctor, ALWAYS);
                }
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        brokenOffsetsConstructors = new HashMap();
        try {
            for (Class c : Arrays.asList(ReversePathHierarchyTokenizer.class, PathHierarchyTokenizer.class, WikipediaTokenizer.class, CJKBigramFilter.class, HyphenatedWordsFilter.class, CommonGramsFilter.class, CommonGramsQueryFilter.class)) {
                for (Constructor<?> ctor : c.getConstructors()) {
                    brokenOffsetsConstructors.put(ctor, ALWAYS);
                }
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        argProducers = new IdentityHashMap<Class<?>, Function<Random, Object>>(){

            private static /* synthetic */ Object lambda$new$21(Random random) {
                return Operations.determinize((Automaton)new RegExp(AutomatonTestUtil.randomRegexp((Random)random), 0).toAutomaton(), (int)10000);
            }

            private static /* synthetic */ Object lambda$new$20(Random random) {
                if (random.nextBoolean()) {
                    return null;
                }
                return DateFormat.getDateInstance(2, LuceneTestCase.randomLocale((Random)random));
            }

            private static /* synthetic */ Object lambda$new$19(Random random) {
                int num = random.nextInt(10);
                StemmerOverrideFilter.Builder builder = new StemmerOverrideFilter.Builder(random.nextBoolean());
                for (int i = 0; i < num; ++i) {
                    String input = "";
                    while ((input = TestUtil.randomRealisticUnicodeString((Random)random)).isEmpty()) {
                    }
                    String out = "";
                    TestUtil.randomSimpleString((Random)random);
                    while ((out = TestUtil.randomRealisticUnicodeString((Random)random)).isEmpty()) {
                    }
                    builder.add((CharSequence)input, (CharSequence)out);
                }
                try {
                    return builder.build();
                }
                catch (Exception ex) {
                    Rethrow.rethrow((Throwable)ex);
                    return null;
                }
            }

            private static /* synthetic */ Object lambda$new$18(Random random) {
                int num = random.nextInt(10);
                CharArrayMap map = new CharArrayMap(num, random.nextBoolean());
                for (int i = 0; i < num; ++i) {
                    map.put(TestUtil.randomSimpleString((Random)random), (Object)TestUtil.randomSimpleString((Random)random));
                }
                return map;
            }

            private static /* synthetic */ Object lambda$new$17(Random random) {
                switch (random.nextInt(5)) {
                    case 0: {
                        return MockTokenizer.KEYWORD;
                    }
                    case 1: {
                        return MockTokenizer.SIMPLE;
                    }
                    case 2: {
                        return MockTokenizer.WHITESPACE;
                    }
                    case 3: {
                        return MockTokenFilter.EMPTY_STOPSET;
                    }
                }
                return MockTokenFilter.ENGLISH_STOPSET;
            }

            private static /* synthetic */ Object lambda$new$16(Random random) {
                NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
                HashSet<String> keys = new HashSet<String>();
                int num = random.nextInt(5);
                for (int i = 0; i < num; ++i) {
                    String key = TestUtil.randomSimpleString((Random)random);
                    if (keys.contains(key) || key.length() <= 0) continue;
                    String value = TestUtil.randomSimpleString((Random)random);
                    builder.add(key, value);
                    keys.add(key);
                }
                return builder.build();
            }

            private static /* synthetic */ Object lambda$new$15(Random random) {
                if (random.nextBoolean()) {
                    return StandardTokenizer.TOKEN_TYPES[random.nextInt(StandardTokenizer.TOKEN_TYPES.length)];
                }
                return TestUtil.randomSimpleString((Random)random);
            }

            private static /* synthetic */ Object lambda$new$14(Random random) {
                try {
                    String lang = TestSnowball.SNOWBALL_LANGS[random.nextInt(TestSnowball.SNOWBALL_LANGS.length)];
                    Class<SnowballProgram> clazz = Class.forName("org.tartarus.snowball.ext." + lang + "Stemmer").asSubclass(SnowballProgram.class);
                    return clazz.newInstance();
                }
                catch (Exception ex) {
                    Rethrow.rethrow((Throwable)ex);
                    return null;
                }
            }

            private static /* synthetic */ Object lambda$new$13(Random random) {
                try {
                    InputSource is = new InputSource(TestCompoundWordTokenFilter.class.getResource("da_UTF8.xml").toExternalForm());
                    HyphenationTree hyphenator = HyphenationCompoundWordTokenFilter.getHyphenationTree((InputSource)is);
                    return hyphenator;
                }
                catch (Exception ex) {
                    Rethrow.rethrow((Throwable)ex);
                    return null;
                }
            }

            private static /* synthetic */ Object lambda$new$12(Random random) {
                InputStream affixStream = TestHunspellStemFilter.class.getResourceAsStream("simple.aff");
                InputStream dictStream = TestHunspellStemFilter.class.getResourceAsStream("simple.dic");
                try {
                    return new Dictionary((Directory)new RAMDirectory(), "dictionary", affixStream, dictStream);
                }
                catch (Exception ex) {
                    Rethrow.rethrow((Throwable)ex);
                    return null;
                }
            }

            private static /* synthetic */ Object lambda$new$11(Random random) {
                return new IdentityEncoder();
            }
        };
        allowedTokenizerArgs = Collections.newSetFromMap(new IdentityHashMap());
        allowedTokenizerArgs.addAll(argProducers.keySet());
        allowedTokenizerArgs.add(Reader.class);
        allowedTokenizerArgs.add(AttributeFactory.class);
        allowedTokenizerArgs.add(AttributeSource.class);
        allowedTokenizerArgs.add(Automaton.class);
        allowedTokenFilterArgs = Collections.newSetFromMap(new IdentityHashMap());
        allowedTokenFilterArgs.addAll(argProducers.keySet());
        allowedTokenFilterArgs.add(TokenStream.class);
        allowedTokenFilterArgs.add(CommonGramsFilter.class);
        allowedCharFilterArgs = Collections.newSetFromMap(new IdentityHashMap());
        allowedCharFilterArgs.addAll(argProducers.keySet());
        allowedCharFilterArgs.add(Reader.class);
    }

    static class CharFilterSpec {
        Reader reader;
        String toString;

        CharFilterSpec() {
        }
    }

    static class TokenFilterSpec {
        TokenStream stream;
        String toString;
        boolean offsetsAreCorrect = true;

        TokenFilterSpec() {
        }
    }

    static class TokenizerSpec {
        Tokenizer tokenizer;
        String toString;
        boolean offsetsAreCorrect = true;

        TokenizerSpec() {
        }
    }

    static class CheckThatYouDidntReadAnythingReaderWrapper
    extends CharFilter {
        boolean readSomething;

        CheckThatYouDidntReadAnythingReaderWrapper(Reader in) {
            super(in);
        }

        public int correct(int currentOff) {
            return currentOff;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            this.readSomething = true;
            return this.input.read(cbuf, off, len);
        }

        public int read() throws IOException {
            this.readSomething = true;
            return this.input.read();
        }

        public int read(CharBuffer target) throws IOException {
            this.readSomething = true;
            return this.input.read(target);
        }

        public int read(char[] cbuf) throws IOException {
            this.readSomething = true;
            return this.input.read(cbuf);
        }

        public long skip(long n) throws IOException {
            this.readSomething = true;
            return this.input.skip(n);
        }

        public void mark(int readAheadLimit) throws IOException {
            this.input.mark(readAheadLimit);
        }

        public boolean markSupported() {
            return this.input.markSupported();
        }

        public boolean ready() throws IOException {
            return this.input.ready();
        }

        public void reset() throws IOException {
            this.input.reset();
        }
    }

    static class MockRandomAnalyzer
    extends Analyzer {
        final long seed;

        MockRandomAnalyzer(long seed) {
            this.seed = seed;
        }

        public boolean offsetsAreCorrect() {
            Random random = new Random(this.seed);
            TokenizerSpec tokenizerSpec = this.newTokenizer(random);
            TokenFilterSpec filterSpec = this.newFilterChain(random, tokenizerSpec.tokenizer, tokenizerSpec.offsetsAreCorrect);
            return filterSpec.offsetsAreCorrect;
        }

        protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
            Random random = new Random(this.seed);
            TokenizerSpec tokenizerSpec = this.newTokenizer(random);
            TokenFilterSpec filterSpec = this.newFilterChain(random, tokenizerSpec.tokenizer, tokenizerSpec.offsetsAreCorrect);
            return new Analyzer.TokenStreamComponents(tokenizerSpec.tokenizer, filterSpec.stream);
        }

        protected Reader initReader(String fieldName, Reader reader) {
            Random random = new Random(this.seed);
            CharFilterSpec charfilterspec = this.newCharFilterChain(random, reader);
            return charfilterspec.reader;
        }

        public String toString() {
            Random random = new Random(this.seed);
            StringBuilder sb = new StringBuilder();
            CharFilterSpec charFilterSpec = this.newCharFilterChain(random, new StringReader(""));
            sb.append("\ncharfilters=");
            sb.append(charFilterSpec.toString);
            random = new Random(this.seed);
            TokenizerSpec tokenizerSpec = this.newTokenizer(random);
            sb.append("\n");
            sb.append("tokenizer=");
            sb.append(tokenizerSpec.toString);
            TokenFilterSpec tokenFilterSpec = this.newFilterChain(random, tokenizerSpec.tokenizer, tokenizerSpec.offsetsAreCorrect);
            sb.append("\n");
            sb.append("filters=");
            sb.append(tokenFilterSpec.toString);
            sb.append("\n");
            sb.append("offsetsAreCorrect=");
            sb.append(tokenFilterSpec.offsetsAreCorrect);
            return sb.toString();
        }

        private <T> T createComponent(Constructor<T> ctor, Object[] args, StringBuilder descr) {
            try {
                T instance = ctor.newInstance(args);
                descr.append("\n  ");
                descr.append(ctor.getDeclaringClass().getName());
                String params = Arrays.deepToString(args);
                params = params.substring(1, params.length() - 1);
                descr.append("(").append(params).append(")");
                return instance;
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof IllegalArgumentException || cause instanceof UnsupportedOperationException) {
                    if (LuceneTestCase.VERBOSE) {
                        System.err.println("Ignoring IAE/UOE from ctor:");
                        cause.printStackTrace(System.err);
                    }
                } else {
                    Rethrow.rethrow((Throwable)cause);
                }
            }
            catch (IllegalAccessException | InstantiationException iae) {
                Rethrow.rethrow((Throwable)iae);
            }
            return null;
        }

        private boolean broken(Constructor<?> ctor, Object[] args) {
            Predicate pred = (Predicate)brokenConstructors.get(ctor);
            return pred != null && pred.test(args);
        }

        private boolean brokenOffsets(Constructor<?> ctor, Object[] args) {
            Predicate pred = (Predicate)brokenOffsetsConstructors.get(ctor);
            return pred != null && pred.test(args);
        }

        private TokenizerSpec newTokenizer(Random random) {
            TokenizerSpec spec = new TokenizerSpec();
            while (spec.tokenizer == null) {
                Constructor<? extends Tokenizer> ctor = tokenizers.get(random.nextInt(tokenizers.size()));
                StringBuilder descr = new StringBuilder();
                Object[] args = TestRandomChains.newTokenizerArgs(random, ctor.getParameterTypes());
                if (this.broken(ctor, args)) continue;
                spec.tokenizer = this.createComponent(ctor, args, descr);
                if (spec.tokenizer == null) continue;
                spec.offsetsAreCorrect = spec.offsetsAreCorrect & !this.brokenOffsets(ctor, args);
                spec.toString = descr.toString();
            }
            return spec;
        }

        private CharFilterSpec newCharFilterChain(Random random, Reader reader) {
            CharFilterSpec spec = new CharFilterSpec();
            spec.reader = reader;
            StringBuilder descr = new StringBuilder();
            int numFilters = random.nextInt(3);
            for (int i = 0; i < numFilters; ++i) {
                Object[] args;
                Constructor<? extends CharFilter> ctor;
                while (this.broken(ctor = charfilters.get(random.nextInt(charfilters.size())), args = TestRandomChains.newCharFilterArgs(random, spec.reader, ctor.getParameterTypes())) || (reader = (Reader)this.createComponent(ctor, args, descr)) == null) {
                }
                spec.reader = reader;
            }
            spec.toString = descr.toString();
            return spec;
        }

        private TokenFilterSpec newFilterChain(Random random, Tokenizer tokenizer, boolean offsetsAreCorrect) {
            TokenFilterSpec spec = new TokenFilterSpec();
            spec.offsetsAreCorrect = offsetsAreCorrect;
            spec.stream = tokenizer;
            StringBuilder descr = new StringBuilder();
            int numFilters = random.nextInt(5);
            for (int i = 0; i < numFilters; ++i) {
                TokenFilter flt;
                Object[] args;
                Constructor<? extends TokenFilter> ctor;
                spec.stream = new ValidatingTokenFilter(spec.stream, "stage " + i, spec.offsetsAreCorrect);
                do {
                    ctor = tokenfilters.get(random.nextInt(tokenfilters.size()));
                } while (!spec.offsetsAreCorrect && (ctor.getDeclaringClass().equals(MockGraphTokenFilter.class) || ctor.getDeclaringClass().equals(MockRandomLookaheadTokenFilter.class)) || this.broken(ctor, args = TestRandomChains.newFilterArgs(random, spec.stream, ctor.getParameterTypes())) || (flt = this.createComponent(ctor, args, descr)) == null);
                spec.offsetsAreCorrect = spec.offsetsAreCorrect & !this.brokenOffsets(ctor, args);
                spec.stream = flt;
            }
            spec.stream = new ValidatingTokenFilter(spec.stream, "last stage", spec.offsetsAreCorrect);
            spec.toString = descr.toString();
            return spec;
        }
    }
}

