/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

public class TestStopAnalyzer
extends BaseTokenStreamTestCase {
    private StopAnalyzer stop;
    private Set<Object> inValidTokens = new HashSet<Object>();

    public void setUp() throws Exception {
        super.setUp();
        Iterator it = StopAnalyzer.ENGLISH_STOP_WORDS_SET.iterator();
        while (it.hasNext()) {
            this.inValidTokens.add(it.next());
        }
        this.stop = new StopAnalyzer();
    }

    public void tearDown() throws Exception {
        this.stop.close();
        super.tearDown();
    }

    public void testDefaults() throws IOException {
        TestStopAnalyzer.assertTrue((this.stop != null ? 1 : 0) != 0);
        try (TokenStream stream = this.stop.tokenStream("test", "This is a test of the english stop analyzer");){
            TestStopAnalyzer.assertTrue((stream != null ? 1 : 0) != 0);
            CharTermAttribute termAtt = (CharTermAttribute)stream.getAttribute(CharTermAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                TestStopAnalyzer.assertFalse((boolean)this.inValidTokens.contains(termAtt.toString()));
            }
            stream.end();
        }
    }

    public void testStopList() throws IOException {
        CharArraySet stopWordsSet = new CharArraySet((Collection)TestStopAnalyzer.asSet((Object[])new String[]{"good", "test", "analyzer"}), false);
        StopAnalyzer newStop = new StopAnalyzer(stopWordsSet);
        try (TokenStream stream = newStop.tokenStream("test", "This is a good test of the english stop analyzer");){
            TestStopAnalyzer.assertNotNull((Object)stream);
            CharTermAttribute termAtt = (CharTermAttribute)stream.getAttribute(CharTermAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                String text = termAtt.toString();
                TestStopAnalyzer.assertFalse((boolean)stopWordsSet.contains((CharSequence)text));
            }
            stream.end();
        }
        newStop.close();
    }

    public void testStopListPositions() throws IOException {
        CharArraySet stopWordsSet = new CharArraySet((Collection)TestStopAnalyzer.asSet((Object[])new String[]{"good", "test", "analyzer"}), false);
        StopAnalyzer newStop = new StopAnalyzer(stopWordsSet);
        String s = "This is a good test of the english stop analyzer with positions";
        int[] expectedIncr = new int[]{1, 1, 1, 3, 1, 1, 1, 2, 1};
        try (TokenStream stream = newStop.tokenStream("test", s);){
            TestStopAnalyzer.assertNotNull((Object)stream);
            int i = 0;
            CharTermAttribute termAtt = (CharTermAttribute)stream.getAttribute(CharTermAttribute.class);
            PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                String text = termAtt.toString();
                TestStopAnalyzer.assertFalse((boolean)stopWordsSet.contains((CharSequence)text));
                TestStopAnalyzer.assertEquals((long)expectedIncr[i++], (long)posIncrAtt.getPositionIncrement());
            }
            stream.end();
        }
        newStop.close();
    }
}

