/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilterFactory;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;
import org.apache.lucene.analysis.util.ClasspathResourceLoader;

public class TestStopFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testInform() throws Exception {
        ClasspathResourceLoader loader = new ClasspathResourceLoader(((Object)((Object)this)).getClass());
        TestStopFilterFactory.assertTrue((String)"loader is null and it shouldn't be", (loader != null ? 1 : 0) != 0);
        StopFilterFactory factory = (StopFilterFactory)this.tokenFilterFactory("Stop", "words", "stop-1.txt", "ignoreCase", "true");
        CharArraySet words = factory.getStopWords();
        TestStopFilterFactory.assertTrue((String)"words is null and it shouldn't be", (words != null ? 1 : 0) != 0);
        TestStopFilterFactory.assertTrue((String)("words Size: " + words.size() + " is not: " + 2), (words.size() == 2 ? 1 : 0) != 0);
        TestStopFilterFactory.assertTrue((String)(factory.isIgnoreCase() + " does not equal: " + true), (factory.isIgnoreCase() ? 1 : 0) != 0);
        factory = (StopFilterFactory)this.tokenFilterFactory("Stop", "words", "stop-1.txt, stop-2.txt", "ignoreCase", "true");
        words = factory.getStopWords();
        TestStopFilterFactory.assertTrue((String)"words is null and it shouldn't be", (words != null ? 1 : 0) != 0);
        TestStopFilterFactory.assertTrue((String)("words Size: " + words.size() + " is not: " + 4), (words.size() == 4 ? 1 : 0) != 0);
        TestStopFilterFactory.assertTrue((String)(factory.isIgnoreCase() + " does not equal: " + true), (factory.isIgnoreCase() ? 1 : 0) != 0);
        factory = (StopFilterFactory)this.tokenFilterFactory("Stop", "words", "stop-snowball.txt", "format", "snowball", "ignoreCase", "true");
        words = factory.getStopWords();
        TestStopFilterFactory.assertEquals((long)8L, (long)words.size());
        TestStopFilterFactory.assertTrue((boolean)words.contains((CharSequence)"he"));
        TestStopFilterFactory.assertTrue((boolean)words.contains((CharSequence)"him"));
        TestStopFilterFactory.assertTrue((boolean)words.contains((CharSequence)"his"));
        TestStopFilterFactory.assertTrue((boolean)words.contains((CharSequence)"himself"));
        TestStopFilterFactory.assertTrue((boolean)words.contains((CharSequence)"she"));
        TestStopFilterFactory.assertTrue((boolean)words.contains((CharSequence)"her"));
        TestStopFilterFactory.assertTrue((boolean)words.contains((CharSequence)"hers"));
        TestStopFilterFactory.assertTrue((boolean)words.contains((CharSequence)"herself"));
        factory = (StopFilterFactory)this.tokenFilterFactory("Stop", new String[0]);
        TestStopFilterFactory.assertEquals((Object)StopAnalyzer.ENGLISH_STOP_WORDS_SET, (Object)factory.getStopWords());
        TestStopFilterFactory.assertEquals((Object)false, (Object)factory.isIgnoreCase());
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestStopFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Stop", "bogusArg", "bogusValue"));
        TestStopFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }

    public void testBogusFormats() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestStopFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Stop", "words", "stop-snowball.txt", "format", "bogus"));
        String msg = expected.getMessage();
        TestStopFilterFactory.assertTrue((String)msg, (boolean)msg.contains("Unknown"));
        TestStopFilterFactory.assertTrue((String)msg, (boolean)msg.contains("format"));
        TestStopFilterFactory.assertTrue((String)msg, (boolean)msg.contains("bogus"));
        expected = (IllegalArgumentException)TestStopFilterFactory.expectThrows(IllegalArgumentException.class, () -> {
            this.tokenFilterFactory("Stop", "format", "bogus");
            TestStopFilterFactory.fail();
        });
        msg = expected.getMessage();
        TestStopFilterFactory.assertTrue((String)msg, (boolean)msg.contains("can not be specified"));
        TestStopFilterFactory.assertTrue((String)msg, (boolean)msg.contains("format"));
        TestStopFilterFactory.assertTrue((String)msg, (boolean)msg.contains("bogus"));
    }
}

