/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.TypeTokenFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.English;

public class TestTypeTokenFilter
extends BaseTokenStreamTestCase {
    public void testTypeFilter() throws IOException {
        StringReader reader = new StringReader("121 is palindrome, while 123 is not");
        Set stopTypes = TestTypeTokenFilter.asSet((Object[])new String[]{"<NUM>"});
        StandardTokenizer input = new StandardTokenizer(TestTypeTokenFilter.newAttributeFactory());
        input.setReader((Reader)reader);
        TypeTokenFilter stream = new TypeTokenFilter((TokenStream)input, stopTypes);
        TestTypeTokenFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"is", "palindrome", "while", "is", "not"});
    }

    public void testStopPositons() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 10; i < 20; ++i) {
            if (i % 3 != 0) {
                sb.append(i).append(" ");
                continue;
            }
            String w = English.intToEnglish((int)i).trim();
            sb.append(w).append(" ");
        }
        TestTypeTokenFilter.log(sb.toString());
        Object[] stopTypes = new String[]{"<NUM>"};
        Set stopSet = TestTypeTokenFilter.asSet((Object[])stopTypes);
        StringReader reader = new StringReader(sb.toString());
        StandardTokenizer input = new StandardTokenizer();
        input.setReader((Reader)reader);
        TypeTokenFilter typeTokenFilter = new TypeTokenFilter((TokenStream)input, stopSet);
        this.testPositons(typeTokenFilter);
    }

    private void testPositons(TypeTokenFilter stpf) throws IOException {
        TypeAttribute typeAtt = (TypeAttribute)stpf.getAttribute(TypeAttribute.class);
        CharTermAttribute termAttribute = (CharTermAttribute)stpf.getAttribute(CharTermAttribute.class);
        PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stpf.getAttribute(PositionIncrementAttribute.class);
        stpf.reset();
        while (stpf.incrementToken()) {
            TestTypeTokenFilter.log("Token: " + termAttribute.toString() + ": " + typeAtt.type() + " - " + posIncrAtt.getPositionIncrement());
            TestTypeTokenFilter.assertEquals((String)"if position increment is enabled the positionIncrementAttribute value should be 3, otherwise 1", (long)posIncrAtt.getPositionIncrement(), (long)3L);
        }
        stpf.end();
        stpf.close();
    }

    public void testTypeFilterWhitelist() throws IOException {
        StringReader reader = new StringReader("121 is palindrome, while 123 is not");
        Set<String> stopTypes = Collections.singleton("<NUM>");
        StandardTokenizer input = new StandardTokenizer(TestTypeTokenFilter.newAttributeFactory());
        input.setReader((Reader)reader);
        TypeTokenFilter stream = new TypeTokenFilter((TokenStream)input, stopTypes, true);
        TestTypeTokenFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"121", "123"});
    }

    private static void log(String s) {
        if (VERBOSE) {
            System.out.println(s);
        }
    }
}

