/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.util.Set;
import org.apache.lucene.analysis.CannedTokenStream;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.TypeTokenFilterFactory;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class TestTypeTokenFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testInform() throws Exception {
        TypeTokenFilterFactory factory = (TypeTokenFilterFactory)this.tokenFilterFactory("Type", "types", "stoptypes-1.txt");
        Set types = factory.getStopTypes();
        TestTypeTokenFilterFactory.assertTrue((String)"types is null and it shouldn't be", (types != null ? 1 : 0) != 0);
        TestTypeTokenFilterFactory.assertTrue((String)("types Size: " + types.size() + " is not: " + 2), (types.size() == 2 ? 1 : 0) != 0);
        factory = (TypeTokenFilterFactory)this.tokenFilterFactory("Type", "types", "stoptypes-1.txt, stoptypes-2.txt", "useWhitelist", "true");
        types = factory.getStopTypes();
        TestTypeTokenFilterFactory.assertTrue((String)"types is null and it shouldn't be", (types != null ? 1 : 0) != 0);
        TestTypeTokenFilterFactory.assertTrue((String)("types Size: " + types.size() + " is not: " + 4), (types.size() == 4 ? 1 : 0) != 0);
    }

    public void testCreationWithBlackList() throws Exception {
        TokenFilterFactory factory = this.tokenFilterFactory("Type", "types", "stoptypes-1.txt, stoptypes-2.txt");
        CannedTokenStream input = new CannedTokenStream(new Token[0]);
        factory.create((TokenStream)input);
    }

    public void testCreationWithWhiteList() throws Exception {
        TokenFilterFactory factory = this.tokenFilterFactory("Type", "types", "stoptypes-1.txt, stoptypes-2.txt", "useWhitelist", "true");
        CannedTokenStream input = new CannedTokenStream(new Token[0]);
        factory.create((TokenStream)input);
    }

    public void testMissingTypesParameter() throws Exception {
        TestTypeTokenFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Type", new String[0]));
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestTypeTokenFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Type", "types", "stoptypes-1.txt", "bogusArg", "bogusValue"));
        TestTypeTokenFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

