/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.UnicodeWhitespaceTokenizer;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.util.AttributeFactory;

public class TestUnicodeWhitespaceTokenizer
extends BaseTokenStreamTestCase {
    public void testSimple() throws IOException {
        StringReader reader = new StringReader("Tokenizer \ud801\udc1ctest");
        UnicodeWhitespaceTokenizer tokenizer = new UnicodeWhitespaceTokenizer();
        tokenizer.setReader((Reader)reader);
        TestUnicodeWhitespaceTokenizer.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"Tokenizer", "\ud801\udc1ctest"});
    }

    public void testNBSP() throws IOException {
        StringReader reader = new StringReader("Tokenizer\u00a0test");
        UnicodeWhitespaceTokenizer tokenizer = new UnicodeWhitespaceTokenizer();
        tokenizer.setReader((Reader)reader);
        TestUnicodeWhitespaceTokenizer.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"Tokenizer", "test"});
    }

    public void testFactory() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("rule", "unicode");
        WhitespaceTokenizerFactory factory = new WhitespaceTokenizerFactory(args);
        AttributeFactory attributeFactory = TestUnicodeWhitespaceTokenizer.newAttributeFactory();
        Tokenizer tokenizer = factory.create(attributeFactory);
        TestUnicodeWhitespaceTokenizer.assertEquals(UnicodeWhitespaceTokenizer.class, tokenizer.getClass());
    }
}

