/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.custom;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilterFactory;
import org.apache.lucene.analysis.charfilter.MappingCharFilterFactory;
import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.LowerCaseTokenizer;
import org.apache.lucene.analysis.core.StopFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilterFactory;
import org.apache.lucene.analysis.standard.ClassicTokenizerFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.MultiTermAwareComponent;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SetOnce;
import org.apache.lucene.util.Version;

public class TestCustomAnalyzer
extends BaseTokenStreamTestCase {
    public void testWhitespaceFactoryWithFolding() throws Exception {
        CustomAnalyzer a = CustomAnalyzer.builder().withTokenizer(WhitespaceTokenizerFactory.class, new String[0]).addTokenFilter(ASCIIFoldingFilterFactory.class, new String[]{"preserveOriginal", "true"}).addTokenFilter(LowerCaseFilterFactory.class, new String[0]).build();
        TestCustomAnalyzer.assertSame(WhitespaceTokenizerFactory.class, a.getTokenizerFactory().getClass());
        TestCustomAnalyzer.assertEquals(Collections.emptyList(), (Object)a.getCharFilterFactories());
        List tokenFilters = a.getTokenFilterFactories();
        TestCustomAnalyzer.assertEquals((long)2L, (long)tokenFilters.size());
        TestCustomAnalyzer.assertSame(ASCIIFoldingFilterFactory.class, ((TokenFilterFactory)tokenFilters.get(0)).getClass());
        TestCustomAnalyzer.assertSame(LowerCaseFilterFactory.class, ((TokenFilterFactory)tokenFilters.get(1)).getClass());
        TestCustomAnalyzer.assertEquals((long)0L, (long)a.getPositionIncrementGap("dummy"));
        TestCustomAnalyzer.assertEquals((long)1L, (long)a.getOffsetGap("dummy"));
        TestCustomAnalyzer.assertSame((Object)Version.LATEST, (Object)a.getVersion());
        TestCustomAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"foo bar FOO BAR", (String[])new String[]{"foo", "bar", "foo", "bar"}, (int[])new int[]{1, 1, 1, 1});
        TestCustomAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"f\u00f6\u00f3 b\u00e4r F\u00d6\u00d6 BAR", (String[])new String[]{"foo", "f\u00f6\u00f3", "bar", "b\u00e4r", "foo", "f\u00f6\u00f6", "bar"}, (int[])new int[]{1, 0, 1, 0, 1, 0, 1});
        a.close();
    }

    public void testWhitespaceWithFolding() throws Exception {
        CustomAnalyzer a = CustomAnalyzer.builder().withTokenizer("whitespace", new String[0]).addTokenFilter("asciifolding", new String[]{"preserveOriginal", "true"}).addTokenFilter("lowercase", new String[0]).build();
        TestCustomAnalyzer.assertSame(WhitespaceTokenizerFactory.class, a.getTokenizerFactory().getClass());
        TestCustomAnalyzer.assertEquals(Collections.emptyList(), (Object)a.getCharFilterFactories());
        List tokenFilters = a.getTokenFilterFactories();
        TestCustomAnalyzer.assertEquals((long)2L, (long)tokenFilters.size());
        TestCustomAnalyzer.assertSame(ASCIIFoldingFilterFactory.class, ((TokenFilterFactory)tokenFilters.get(0)).getClass());
        TestCustomAnalyzer.assertSame(LowerCaseFilterFactory.class, ((TokenFilterFactory)tokenFilters.get(1)).getClass());
        TestCustomAnalyzer.assertEquals((long)0L, (long)a.getPositionIncrementGap("dummy"));
        TestCustomAnalyzer.assertEquals((long)1L, (long)a.getOffsetGap("dummy"));
        TestCustomAnalyzer.assertSame((Object)Version.LATEST, (Object)a.getVersion());
        TestCustomAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"foo bar FOO BAR", (String[])new String[]{"foo", "bar", "foo", "bar"}, (int[])new int[]{1, 1, 1, 1});
        TestCustomAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"f\u00f6\u00f3 b\u00e4r F\u00d6\u00d6 BAR", (String[])new String[]{"foo", "f\u00f6\u00f3", "bar", "b\u00e4r", "foo", "f\u00f6\u00f6", "bar"}, (int[])new int[]{1, 0, 1, 0, 1, 0, 1});
        a.close();
    }

    public void testFactoryHtmlStripClassicFolding() throws Exception {
        CustomAnalyzer a = CustomAnalyzer.builder().withDefaultMatchVersion(Version.LUCENE_5_0_0).addCharFilter(HTMLStripCharFilterFactory.class, new String[0]).withTokenizer(ClassicTokenizerFactory.class, new String[0]).addTokenFilter(ASCIIFoldingFilterFactory.class, new String[]{"preserveOriginal", "true"}).addTokenFilter(LowerCaseFilterFactory.class, new String[0]).withPositionIncrementGap(100).withOffsetGap(1000).build();
        TestCustomAnalyzer.assertSame(ClassicTokenizerFactory.class, a.getTokenizerFactory().getClass());
        List charFilters = a.getCharFilterFactories();
        TestCustomAnalyzer.assertEquals((long)1L, (long)charFilters.size());
        TestCustomAnalyzer.assertEquals(HTMLStripCharFilterFactory.class, ((CharFilterFactory)charFilters.get(0)).getClass());
        List tokenFilters = a.getTokenFilterFactories();
        TestCustomAnalyzer.assertEquals((long)2L, (long)tokenFilters.size());
        TestCustomAnalyzer.assertSame(ASCIIFoldingFilterFactory.class, ((TokenFilterFactory)tokenFilters.get(0)).getClass());
        TestCustomAnalyzer.assertSame(LowerCaseFilterFactory.class, ((TokenFilterFactory)tokenFilters.get(1)).getClass());
        TestCustomAnalyzer.assertEquals((long)100L, (long)a.getPositionIncrementGap("dummy"));
        TestCustomAnalyzer.assertEquals((long)1000L, (long)a.getOffsetGap("dummy"));
        TestCustomAnalyzer.assertSame((Object)Version.LUCENE_5_0_0, (Object)a.getVersion());
        TestCustomAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"<p>foo bar</p> FOO BAR", (String[])new String[]{"foo", "bar", "foo", "bar"}, (int[])new int[]{1, 1, 1, 1});
        TestCustomAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"<p><b>f\u00f6\u00f3</b> b\u00e4r     F\u00d6\u00d6 BAR</p>", (String[])new String[]{"foo", "f\u00f6\u00f3", "bar", "b\u00e4r", "foo", "f\u00f6\u00f6", "bar"}, (int[])new int[]{1, 0, 1, 0, 1, 0, 1});
        a.close();
    }

    public void testHtmlStripClassicFolding() throws Exception {
        CustomAnalyzer a = CustomAnalyzer.builder().withDefaultMatchVersion(Version.LUCENE_5_0_0).addCharFilter("htmlstrip", new String[0]).withTokenizer("classic", new String[0]).addTokenFilter("asciifolding", new String[]{"preserveOriginal", "true"}).addTokenFilter("lowercase", new String[0]).withPositionIncrementGap(100).withOffsetGap(1000).build();
        TestCustomAnalyzer.assertSame(ClassicTokenizerFactory.class, a.getTokenizerFactory().getClass());
        List charFilters = a.getCharFilterFactories();
        TestCustomAnalyzer.assertEquals((long)1L, (long)charFilters.size());
        TestCustomAnalyzer.assertEquals(HTMLStripCharFilterFactory.class, ((CharFilterFactory)charFilters.get(0)).getClass());
        List tokenFilters = a.getTokenFilterFactories();
        TestCustomAnalyzer.assertEquals((long)2L, (long)tokenFilters.size());
        TestCustomAnalyzer.assertSame(ASCIIFoldingFilterFactory.class, ((TokenFilterFactory)tokenFilters.get(0)).getClass());
        TestCustomAnalyzer.assertSame(LowerCaseFilterFactory.class, ((TokenFilterFactory)tokenFilters.get(1)).getClass());
        TestCustomAnalyzer.assertEquals((long)100L, (long)a.getPositionIncrementGap("dummy"));
        TestCustomAnalyzer.assertEquals((long)1000L, (long)a.getOffsetGap("dummy"));
        TestCustomAnalyzer.assertSame((Object)Version.LUCENE_5_0_0, (Object)a.getVersion());
        TestCustomAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"<p>foo bar</p> FOO BAR", (String[])new String[]{"foo", "bar", "foo", "bar"}, (int[])new int[]{1, 1, 1, 1});
        TestCustomAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"<p><b>f\u00f6\u00f3</b> b\u00e4r     F\u00d6\u00d6 BAR</p>", (String[])new String[]{"foo", "f\u00f6\u00f3", "bar", "b\u00e4r", "foo", "f\u00f6\u00f6", "bar"}, (int[])new int[]{1, 0, 1, 0, 1, 0, 1});
        a.close();
    }

    public void testStopWordsFromClasspath() throws Exception {
        CustomAnalyzer a = CustomAnalyzer.builder().withTokenizer(WhitespaceTokenizerFactory.class, new String[0]).addTokenFilter("stop", new String[]{"ignoreCase", "true", "words", "org/apache/lucene/analysis/custom/teststop.txt", "format", "wordset"}).build();
        TestCustomAnalyzer.assertSame(WhitespaceTokenizerFactory.class, a.getTokenizerFactory().getClass());
        TestCustomAnalyzer.assertEquals(Collections.emptyList(), (Object)a.getCharFilterFactories());
        List tokenFilters = a.getTokenFilterFactories();
        TestCustomAnalyzer.assertEquals((long)1L, (long)tokenFilters.size());
        TestCustomAnalyzer.assertSame(StopFilterFactory.class, ((TokenFilterFactory)tokenFilters.get(0)).getClass());
        TestCustomAnalyzer.assertEquals((long)0L, (long)a.getPositionIncrementGap("dummy"));
        TestCustomAnalyzer.assertEquals((long)1L, (long)a.getOffsetGap("dummy"));
        TestCustomAnalyzer.assertSame((Object)Version.LATEST, (Object)a.getVersion());
        TestCustomAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"foo Foo Bar", (String[])new String[0]);
        a.close();
    }

    public void testStopWordsFromClasspathWithMap() throws Exception {
        HashMap<String, String> stopConfig1 = new HashMap<String, String>();
        stopConfig1.put("ignoreCase", "true");
        stopConfig1.put("words", "org/apache/lucene/analysis/custom/teststop.txt");
        stopConfig1.put("format", "wordset");
        HashMap stopConfig2 = new HashMap(stopConfig1);
        Map stopConfigImmutable = Collections.unmodifiableMap(new HashMap(stopConfig1));
        CustomAnalyzer a = CustomAnalyzer.builder().withTokenizer("whitespace", new String[0]).addTokenFilter("stop", stopConfig1).build();
        TestCustomAnalyzer.assertTrue((boolean)stopConfig1.isEmpty());
        TestCustomAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"foo Foo Bar", (String[])new String[0]);
        a = CustomAnalyzer.builder().withTokenizer(WhitespaceTokenizerFactory.class, new String[0]).addTokenFilter(StopFilterFactory.class, stopConfig2).build();
        TestCustomAnalyzer.assertTrue((boolean)stopConfig2.isEmpty());
        TestCustomAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"foo Foo Bar", (String[])new String[0]);
        TestCustomAnalyzer.expectThrows(UnsupportedOperationException.class, () -> CustomAnalyzer.builder().withTokenizer("whitespace", new String[0]).addTokenFilter("stop", stopConfigImmutable).build());
        a.close();
    }

    public void testStopWordsFromFile() throws Exception {
        CustomAnalyzer a = CustomAnalyzer.builder((Path)this.getDataPath("")).withTokenizer("whitespace", new String[0]).addTokenFilter("stop", new String[]{"ignoreCase", "true", "words", "teststop.txt", "format", "wordset"}).build();
        TestCustomAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"foo Foo Bar", (String[])new String[0]);
        a.close();
    }

    public void testStopWordsFromFileAbsolute() throws Exception {
        CustomAnalyzer a = CustomAnalyzer.builder((Path)Paths.get(".", new String[0])).withTokenizer("whitespace", new String[0]).addTokenFilter("stop", new String[]{"ignoreCase", "true", "words", this.getDataPath("teststop.txt").toString(), "format", "wordset"}).build();
        TestCustomAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"foo Foo Bar", (String[])new String[0]);
        a.close();
    }

    public void testIncorrectOrder() throws Exception {
        TestCustomAnalyzer.expectThrows(IllegalStateException.class, () -> CustomAnalyzer.builder().addCharFilter("htmlstrip", new String[0]).withDefaultMatchVersion(Version.LATEST).withTokenizer("whitespace", new String[0]).build());
    }

    public void testMissingSPI() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestCustomAnalyzer.expectThrows(IllegalArgumentException.class, () -> CustomAnalyzer.builder().withTokenizer("foobar_nonexistent", new String[0]).build());
        TestCustomAnalyzer.assertTrue((boolean)expected.getMessage().contains("SPI"));
        TestCustomAnalyzer.assertTrue((boolean)expected.getMessage().contains("does not exist"));
    }

    public void testSetTokenizerTwice() throws Exception {
        TestCustomAnalyzer.expectThrows(SetOnce.AlreadySetException.class, () -> CustomAnalyzer.builder().withTokenizer("whitespace", new String[0]).withTokenizer(StandardTokenizerFactory.class, new String[0]).build());
    }

    public void testSetMatchVersionTwice() throws Exception {
        TestCustomAnalyzer.expectThrows(SetOnce.AlreadySetException.class, () -> CustomAnalyzer.builder().withDefaultMatchVersion(Version.LATEST).withDefaultMatchVersion(Version.LATEST).withTokenizer("standard", new String[0]).build());
    }

    public void testSetPosIncTwice() throws Exception {
        TestCustomAnalyzer.expectThrows(SetOnce.AlreadySetException.class, () -> CustomAnalyzer.builder().withPositionIncrementGap(2).withPositionIncrementGap(3).withTokenizer("standard", new String[0]).build());
    }

    public void testSetOfsGapTwice() throws Exception {
        TestCustomAnalyzer.expectThrows(SetOnce.AlreadySetException.class, () -> CustomAnalyzer.builder().withOffsetGap(2).withOffsetGap(3).withTokenizer("standard", new String[0]).build());
    }

    public void testNoTokenizer() throws Exception {
        TestCustomAnalyzer.expectThrows(IllegalStateException.class, () -> CustomAnalyzer.builder().build());
    }

    public void testNullTokenizer() throws Exception {
        TestCustomAnalyzer.expectThrows(NullPointerException.class, () -> CustomAnalyzer.builder().withTokenizer((String)null, new String[0]).build());
    }

    public void testNullTokenizerFactory() throws Exception {
        TestCustomAnalyzer.expectThrows(NullPointerException.class, () -> CustomAnalyzer.builder().withTokenizer((Class)null, new String[0]).build());
    }

    public void testNullParamKey() throws Exception {
        TestCustomAnalyzer.expectThrows(NullPointerException.class, () -> CustomAnalyzer.builder().withTokenizer("whitespace", new String[]{null, "foo"}).build());
    }

    public void testNullMatchVersion() throws Exception {
        TestCustomAnalyzer.expectThrows(NullPointerException.class, () -> CustomAnalyzer.builder().withDefaultMatchVersion(null).withTokenizer("whitespace", new String[0]).build());
    }

    public void testNormalization() throws IOException {
        CustomAnalyzer analyzer1 = CustomAnalyzer.builder().withTokenizer(DummyTokenizerFactory.class, Collections.emptyMap()).addCharFilter(DummyCharFilterFactory.class, Collections.emptyMap()).addTokenFilter(DummyTokenFilterFactory.class, Collections.emptyMap()).build();
        TestCustomAnalyzer.assertEquals((Object)new BytesRef((CharSequence)"0\u00c0"), (Object)analyzer1.normalize("dummy", "0\u00c0"));
        CustomAnalyzer analyzer2 = CustomAnalyzer.builder().withTokenizer(DummyMultiTermAwareTokenizerFactory.class, Collections.emptyMap()).addCharFilter(DummyMultiTermAwareCharFilterFactory.class, Collections.emptyMap()).addTokenFilter(DummyMultiTermAwareTokenFilterFactory.class, Collections.emptyMap()).build();
        TestCustomAnalyzer.assertEquals((Object)new BytesRef((CharSequence)"2A"), (Object)analyzer2.normalize("dummy", "0\u00c0"));
    }

    public void testNormalizationWithMultipleTokenFilters() throws IOException {
        CustomAnalyzer analyzer = CustomAnalyzer.builder().withTokenizer(WhitespaceTokenizerFactory.class, Collections.emptyMap()).addTokenFilter(LowerCaseFilterFactory.class, Collections.emptyMap()).addTokenFilter(ASCIIFoldingFilterFactory.class, Collections.emptyMap()).build();
        TestCustomAnalyzer.assertEquals((Object)new BytesRef((CharSequence)"a b e"), (Object)analyzer.normalize("dummy", "\u00c0 B \u00e9"));
    }

    public void testNormalizationWithMultiplCharFilters() throws IOException {
        CustomAnalyzer analyzer = CustomAnalyzer.builder().withTokenizer(WhitespaceTokenizerFactory.class, Collections.emptyMap()).addCharFilter(MappingCharFilterFactory.class, new HashMap<String, String>(Collections.singletonMap("mapping", "org/apache/lucene/analysis/custom/mapping1.txt"))).addCharFilter(MappingCharFilterFactory.class, new HashMap<String, String>(Collections.singletonMap("mapping", "org/apache/lucene/analysis/custom/mapping2.txt"))).build();
        TestCustomAnalyzer.assertEquals((Object)new BytesRef((CharSequence)"e f c"), (Object)analyzer.normalize("dummy", "a b c"));
    }

    public static class DummyMultiTermAwareTokenFilterFactory
    extends DummyTokenFilterFactory
    implements MultiTermAwareComponent {
        public DummyMultiTermAwareTokenFilterFactory(Map<String, String> args) {
            super(args);
        }

        public AbstractAnalysisFactory getMultiTermComponent() {
            return new ASCIIFoldingFilterFactory(Collections.emptyMap());
        }
    }

    public static class DummyTokenFilterFactory
    extends TokenFilterFactory {
        public DummyTokenFilterFactory(Map<String, String> args) {
            super(args);
        }

        public TokenStream create(TokenStream input) {
            return input;
        }
    }

    public static class DummyMultiTermAwareTokenizerFactory
    extends DummyTokenizerFactory
    implements MultiTermAwareComponent {
        public DummyMultiTermAwareTokenizerFactory(Map<String, String> args) {
            super(args);
        }

        public AbstractAnalysisFactory getMultiTermComponent() {
            return new KeywordTokenizerFactory(this.getOriginalArgs());
        }
    }

    public static class DummyTokenizerFactory
    extends TokenizerFactory {
        public DummyTokenizerFactory(Map<String, String> args) {
            super(args);
        }

        public Tokenizer create(AttributeFactory factory) {
            return new LowerCaseTokenizer(factory);
        }
    }

    public static class DummyMultiTermAwareCharFilterFactory
    extends DummyCharFilterFactory
    implements MultiTermAwareComponent {
        public DummyMultiTermAwareCharFilterFactory(Map<String, String> args) {
            super(args);
        }

        public AbstractAnalysisFactory getMultiTermComponent() {
            return new DummyCharFilterFactory(Collections.emptyMap(), '0', '2');
        }
    }

    public static class DummyCharFilterFactory
    extends CharFilterFactory {
        private final char match;
        private final char repl;

        public DummyCharFilterFactory(Map<String, String> args) {
            this(args, '0', '1');
        }

        DummyCharFilterFactory(Map<String, String> args, char match, char repl) {
            super(args);
            this.match = match;
            this.repl = repl;
        }

        public Reader create(Reader input) {
            return new DummyCharFilter(input, this.match, this.repl);
        }
    }

    private static class DummyCharFilter
    extends CharFilter {
        private final char match;
        private final char repl;

        public DummyCharFilter(Reader input, char match, char repl) {
            super(input);
            this.match = match;
            this.repl = repl;
        }

        protected int correct(int currentOff) {
            return currentOff;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int read = this.input.read(cbuf, off, len);
            for (int i = 0; i < read; ++i) {
                if (cbuf[off + i] != this.match) continue;
                cbuf[off + i] = this.repl;
            }
            return read;
        }
    }
}

