/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cz;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.cz.CzechAnalyzer;

public class TestCzechAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new CzechAnalyzer().close();
    }

    public void testStopWord() throws Exception {
        CzechAnalyzer analyzer = new CzechAnalyzer();
        TestCzechAnalyzer.assertAnalyzesTo((Analyzer)analyzer, (String)"Pokud mluvime o volnem", (String[])new String[]{"mluvim", "voln"});
        analyzer.close();
    }

    public void testReusableTokenStream() throws Exception {
        CzechAnalyzer analyzer = new CzechAnalyzer();
        TestCzechAnalyzer.assertAnalyzesTo((Analyzer)analyzer, (String)"Pokud mluvime o volnem", (String[])new String[]{"mluvim", "voln"});
        TestCzechAnalyzer.assertAnalyzesTo((Analyzer)analyzer, (String)"\u010cesk\u00e1 Republika", (String[])new String[]{"\u010desk", "republik"});
        analyzer.close();
    }

    public void testWithStemExclusionSet() throws IOException {
        CharArraySet set = new CharArraySet(1, true);
        set.add("hole");
        CzechAnalyzer cz = new CzechAnalyzer(CharArraySet.EMPTY_SET, set);
        TestCzechAnalyzer.assertAnalyzesTo((Analyzer)cz, (String)"hole desek", (String[])new String[]{"hole", "desk"});
        cz.close();
    }

    public void testRandomStrings() throws Exception {
        CzechAnalyzer analyzer = new CzechAnalyzer();
        TestCzechAnalyzer.checkRandomData((Random)TestCzechAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

