/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cz;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.cz.CzechStemFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;

public class TestCzechStemmer
extends BaseTokenStreamTestCase {
    public void testMasculineNouns() throws IOException {
        CzechAnalyzer cz = new CzechAnalyzer();
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00e1n", (String[])new String[]{"p\u00e1n"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00e1ni", (String[])new String[]{"p\u00e1n"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00e1nov\u00e9", (String[])new String[]{"p\u00e1n"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00e1na", (String[])new String[]{"p\u00e1n"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00e1n\u016f", (String[])new String[]{"p\u00e1n"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00e1novi", (String[])new String[]{"p\u00e1n"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00e1n\u016fm", (String[])new String[]{"p\u00e1n"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00e1ny", (String[])new String[]{"p\u00e1n"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00e1ne", (String[])new String[]{"p\u00e1n"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00e1nech", (String[])new String[]{"p\u00e1n"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00e1nem", (String[])new String[]{"p\u00e1n"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"hrad", (String[])new String[]{"hrad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"hradu", (String[])new String[]{"hrad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"hrade", (String[])new String[]{"hrad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"hradem", (String[])new String[]{"hrad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"hrady", (String[])new String[]{"hrad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"hradech", (String[])new String[]{"hrad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"hrad\u016fm", (String[])new String[]{"hrad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"hrad\u016f", (String[])new String[]{"hrad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mu\u017e", (String[])new String[]{"muh"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mu\u017ei", (String[])new String[]{"muh"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mu\u017ee", (String[])new String[]{"muh"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mu\u017e\u016f", (String[])new String[]{"muh"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mu\u017e\u016fm", (String[])new String[]{"muh"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mu\u017e\u00edch", (String[])new String[]{"muh"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mu\u017eem", (String[])new String[]{"muh"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"stroj", (String[])new String[]{"stroj"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"stroje", (String[])new String[]{"stroj"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"stroj\u016f", (String[])new String[]{"stroj"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"stroji", (String[])new String[]{"stroj"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"stroj\u016fm", (String[])new String[]{"stroj"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"stroj\u00edch", (String[])new String[]{"stroj"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"strojem", (String[])new String[]{"stroj"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u0159edseda", (String[])new String[]{"p\u0159edsd"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u0159edsedov\u00e9", (String[])new String[]{"p\u0159edsd"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u0159edsedy", (String[])new String[]{"p\u0159edsd"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u0159edsed\u016f", (String[])new String[]{"p\u0159edsd"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u0159edsedovi", (String[])new String[]{"p\u0159edsd"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u0159edsed\u016fm", (String[])new String[]{"p\u0159edsd"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u0159edsedu", (String[])new String[]{"p\u0159edsd"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u0159edsedo", (String[])new String[]{"p\u0159edsd"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u0159edsedech", (String[])new String[]{"p\u0159edsd"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u0159edsedou", (String[])new String[]{"p\u0159edsd"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"soudce", (String[])new String[]{"soudk"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"soudci", (String[])new String[]{"soudk"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"soudc\u016f", (String[])new String[]{"soudk"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"soudc\u016fm", (String[])new String[]{"soudk"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"soudc\u00edch", (String[])new String[]{"soudk"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"soudcem", (String[])new String[]{"soudk"});
        cz.close();
    }

    public void testFeminineNouns() throws IOException {
        CzechAnalyzer cz = new CzechAnalyzer();
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"kost", (String[])new String[]{"kost"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"kosti", (String[])new String[]{"kost"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"kost\u00ed", (String[])new String[]{"kost"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"kostem", (String[])new String[]{"kost"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"kostech", (String[])new String[]{"kost"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"kostmi", (String[])new String[]{"kost"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00edse\u0148", (String[])new String[]{"p\u00eds\u0148"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00edsn\u011b", (String[])new String[]{"p\u00edsn"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00edsni", (String[])new String[]{"p\u00edsn"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00edsn\u011bmi", (String[])new String[]{"p\u00edsn"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00edsn\u00edch", (String[])new String[]{"p\u00edsn"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"p\u00edsn\u00edm", (String[])new String[]{"p\u00edsn"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"r\u016f\u017ee", (String[])new String[]{"r\u016fh"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"r\u016f\u017e\u00ed", (String[])new String[]{"r\u016fh"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"r\u016f\u017e\u00edm", (String[])new String[]{"r\u016fh"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"r\u016f\u017e\u00edch", (String[])new String[]{"r\u016fh"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"r\u016f\u017eemi", (String[])new String[]{"r\u016fh"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"r\u016f\u017ei", (String[])new String[]{"r\u016fh"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"\u017eena", (String[])new String[]{"\u017en"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"\u017eeny", (String[])new String[]{"\u017en"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"\u017een", (String[])new String[]{"\u017en"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"\u017een\u011b", (String[])new String[]{"\u017en"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"\u017een\u00e1m", (String[])new String[]{"\u017en"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"\u017eenu", (String[])new String[]{"\u017en"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"\u017eeno", (String[])new String[]{"\u017en"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"\u017een\u00e1ch", (String[])new String[]{"\u017en"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"\u017eenou", (String[])new String[]{"\u017en"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"\u017eenami", (String[])new String[]{"\u017en"});
        cz.close();
    }

    public void testNeuterNouns() throws IOException {
        CzechAnalyzer cz = new CzechAnalyzer();
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"m\u011bsto", (String[])new String[]{"m\u011bst"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"m\u011bsta", (String[])new String[]{"m\u011bst"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"m\u011bst", (String[])new String[]{"m\u011bst"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"m\u011bstu", (String[])new String[]{"m\u011bst"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"m\u011bst\u016fm", (String[])new String[]{"m\u011bst"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"m\u011bst\u011b", (String[])new String[]{"m\u011bst"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"m\u011bstech", (String[])new String[]{"m\u011bst"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"m\u011bstem", (String[])new String[]{"m\u011bst"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"m\u011bsty", (String[])new String[]{"m\u011bst"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mo\u0159e", (String[])new String[]{"mo\u0159"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mo\u0159\u00ed", (String[])new String[]{"mo\u0159"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mo\u0159\u00edm", (String[])new String[]{"mo\u0159"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mo\u0159i", (String[])new String[]{"mo\u0159"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mo\u0159\u00edch", (String[])new String[]{"mo\u0159"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mo\u0159em", (String[])new String[]{"mo\u0159"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"ku\u0159e", (String[])new String[]{"ku\u0159"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"ku\u0159ata", (String[])new String[]{"ku\u0159"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"ku\u0159ete", (String[])new String[]{"ku\u0159"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"ku\u0159at", (String[])new String[]{"ku\u0159"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"ku\u0159eti", (String[])new String[]{"ku\u0159"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"ku\u0159at\u016fm", (String[])new String[]{"ku\u0159"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"ku\u0159atech", (String[])new String[]{"ku\u0159"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"ku\u0159etem", (String[])new String[]{"ku\u0159"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"ku\u0159aty", (String[])new String[]{"ku\u0159"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"staven\u00ed", (String[])new String[]{"stavn"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"staven\u00edm", (String[])new String[]{"stavn"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"staven\u00edch", (String[])new String[]{"stavn"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"staven\u00edmi", (String[])new String[]{"stavn"});
        cz.close();
    }

    public void testAdjectives() throws IOException {
        CzechAnalyzer cz = new CzechAnalyzer();
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mlad\u00fd", (String[])new String[]{"mlad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mlad\u00ed", (String[])new String[]{"mlad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mlad\u00e9ho", (String[])new String[]{"mlad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mlad\u00fdch", (String[])new String[]{"mlad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mlad\u00e9mu", (String[])new String[]{"mlad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mlad\u00fdm", (String[])new String[]{"mlad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mlad\u00e9", (String[])new String[]{"mlad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mlad\u00e9m", (String[])new String[]{"mlad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mlad\u00fdmi", (String[])new String[]{"mlad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mlad\u00e1", (String[])new String[]{"mlad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mladou", (String[])new String[]{"mlad"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"jarn\u00ed", (String[])new String[]{"jarn"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"jarn\u00edho", (String[])new String[]{"jarn"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"jarn\u00edch", (String[])new String[]{"jarn"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"jarn\u00edmu", (String[])new String[]{"jarn"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"jarn\u00edm", (String[])new String[]{"jarn"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"jarn\u00edmi", (String[])new String[]{"jarn"});
        cz.close();
    }

    public void testPossessive() throws IOException {
        CzechAnalyzer cz = new CzechAnalyzer();
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"Karl\u016fv", (String[])new String[]{"karl"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"jazykov\u00fd", (String[])new String[]{"jazyk"});
        cz.close();
    }

    public void testExceptions() throws IOException {
        CzechAnalyzer cz = new CzechAnalyzer();
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"\u010desk\u00fd", (String[])new String[]{"\u010desk"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"\u010de\u0161t\u00ed", (String[])new String[]{"\u010desk"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"anglick\u00fd", (String[])new String[]{"anglick"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"angli\u010dt\u00ed", (String[])new String[]{"anglick"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"kniha", (String[])new String[]{"knih"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"knize", (String[])new String[]{"knih"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"mazat", (String[])new String[]{"mah"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"ma\u017eu", (String[])new String[]{"mah"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"kluk", (String[])new String[]{"kluk"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"kluci", (String[])new String[]{"kluk"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"kluc\u00edch", (String[])new String[]{"kluk"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"hezk\u00fd", (String[])new String[]{"hezk"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"hez\u010d\u00ed", (String[])new String[]{"hezk"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"h\u016fl", (String[])new String[]{"hol"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"hole", (String[])new String[]{"hol"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"deska", (String[])new String[]{"desk"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"desek", (String[])new String[]{"desk"});
        cz.close();
    }

    public void testDontStem() throws IOException {
        CzechAnalyzer cz = new CzechAnalyzer();
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"e", (String[])new String[]{"e"});
        TestCzechStemmer.assertAnalyzesTo((Analyzer)cz, (String)"zi", (String[])new String[]{"zi"});
        cz.close();
    }

    public void testWithKeywordAttribute() throws IOException {
        CharArraySet set = new CharArraySet(1, true);
        set.add("hole");
        MockTokenizer in = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        in.setReader((Reader)new StringReader("hole desek"));
        CzechStemFilter filter = new CzechStemFilter((TokenStream)new SetKeywordMarkerFilter((TokenStream)in, set));
        TestCzechStemmer.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"hole", "desk"});
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new CzechStemFilter((TokenStream)tokenizer));
            }
        };
        TestCzechStemmer.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

