/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.da;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.da.DanishAnalyzer;

public class TestDanishAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new DanishAnalyzer().close();
    }

    public void testBasics() throws IOException {
        DanishAnalyzer a = new DanishAnalyzer();
        TestDanishAnalyzer.checkOneTerm((Analyzer)a, (String)"unders\u00f8g", (String)"unders\u00f8g");
        TestDanishAnalyzer.checkOneTerm((Analyzer)a, (String)"unders\u00f8gelse", (String)"unders\u00f8g");
        TestDanishAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"p\u00e5", (String[])new String[0]);
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestDanishAnalyzer.asSet((Object[])new String[]{"unders\u00f8gelse"}), false);
        DanishAnalyzer a = new DanishAnalyzer(DanishAnalyzer.getDefaultStopSet(), exclusionSet);
        TestDanishAnalyzer.checkOneTerm((Analyzer)a, (String)"unders\u00f8gelse", (String)"unders\u00f8gelse");
        TestDanishAnalyzer.checkOneTerm((Analyzer)a, (String)"unders\u00f8g", (String)"unders\u00f8g");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        DanishAnalyzer analyzer = new DanishAnalyzer();
        TestDanishAnalyzer.checkRandomData((Random)TestDanishAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

