/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LowerCaseTokenizer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;

public class TestGermanAnalyzer
extends BaseTokenStreamTestCase {
    public void testReusableTokenStream() throws Exception {
        GermanAnalyzer a = new GermanAnalyzer();
        TestGermanAnalyzer.checkOneTerm((Analyzer)a, (String)"Tisch", (String)"tisch");
        TestGermanAnalyzer.checkOneTerm((Analyzer)a, (String)"Tische", (String)"tisch");
        TestGermanAnalyzer.checkOneTerm((Analyzer)a, (String)"Tischen", (String)"tisch");
        a.close();
    }

    public void testWithKeywordAttribute() throws IOException {
        CharArraySet set = new CharArraySet(1, true);
        set.add("fischen");
        LowerCaseTokenizer in = new LowerCaseTokenizer();
        in.setReader((Reader)new StringReader("Fischen Trinken"));
        GermanStemFilter filter = new GermanStemFilter((TokenStream)new SetKeywordMarkerFilter((TokenStream)in, set));
        TestGermanAnalyzer.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"fischen", "trink"});
    }

    public void testStemExclusionTable() throws Exception {
        GermanAnalyzer a = new GermanAnalyzer(CharArraySet.EMPTY_SET, new CharArraySet((Collection)TestGermanAnalyzer.asSet((Object[])new String[]{"tischen"}), false));
        TestGermanAnalyzer.checkOneTerm((Analyzer)a, (String)"tischen", (String)"tischen");
        a.close();
    }

    public void testGermanSpecials() throws Exception {
        GermanAnalyzer a = new GermanAnalyzer();
        TestGermanAnalyzer.checkOneTerm((Analyzer)a, (String)"Schaltfl\u00e4chen", (String)"schaltflach");
        TestGermanAnalyzer.checkOneTerm((Analyzer)a, (String)"Schaltflaechen", (String)"schaltflach");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        GermanAnalyzer a = new GermanAnalyzer();
        TestGermanAnalyzer.checkRandomData((Random)TestGermanAnalyzer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }
}

