/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.VocabularyAssert;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.de.GermanLightStemFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;

public class TestGermanLightStemFilter
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new GermanLightStemFilter((TokenStream)source));
            }
        };
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void testVocabulary() throws IOException {
        VocabularyAssert.assertVocabulary((Analyzer)this.analyzer, (Path)this.getDataPath("delighttestdata.zip"), (String)"delight.txt");
    }

    public void testKeyword() throws IOException {
        final CharArraySet exclusionSet = new CharArraySet((Collection)TestGermanLightStemFilter.asSet((Object[])new String[]{"s\u00e4ngerinnen"}), false);
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                SetKeywordMarkerFilter sink = new SetKeywordMarkerFilter((TokenStream)source, exclusionSet);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new GermanLightStemFilter((TokenStream)sink));
            }
        };
        TestGermanLightStemFilter.checkOneTerm((Analyzer)a, (String)"s\u00e4ngerinnen", (String)"s\u00e4ngerinnen");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        TestGermanLightStemFilter.checkRandomData((Random)TestGermanLightStemFilter.random(), (Analyzer)this.analyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new GermanLightStemFilter((TokenStream)tokenizer));
            }
        };
        TestGermanLightStemFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

