/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.VocabularyAssert;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.de.GermanMinimalStemFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;

public class TestGermanMinimalStemFilter
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new GermanMinimalStemFilter((TokenStream)source));
            }
        };
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void testExamples() throws IOException {
        TestGermanMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"s\u00e4ngerinnen", (String)"sangerin");
        TestGermanMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"frauen", (String)"frau");
        TestGermanMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"kenntnisse", (String)"kenntnis");
        TestGermanMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"staates", (String)"staat");
        TestGermanMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"bilder", (String)"bild");
        TestGermanMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"boote", (String)"boot");
        TestGermanMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"g\u00f6tter", (String)"gott");
        TestGermanMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00e4pfel", (String)"apfel");
    }

    public void testKeyword() throws IOException {
        final CharArraySet exclusionSet = new CharArraySet((Collection)TestGermanMinimalStemFilter.asSet((Object[])new String[]{"s\u00e4ngerinnen"}), false);
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                SetKeywordMarkerFilter sink = new SetKeywordMarkerFilter((TokenStream)source, exclusionSet);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new GermanMinimalStemFilter((TokenStream)sink));
            }
        };
        TestGermanMinimalStemFilter.checkOneTerm((Analyzer)a, (String)"s\u00e4ngerinnen", (String)"s\u00e4ngerinnen");
        a.close();
    }

    public void testVocabulary() throws IOException {
        VocabularyAssert.assertVocabulary((Analyzer)this.analyzer, (Path)this.getDataPath("deminimaltestdata.zip"), (String)"deminimal.txt");
    }

    public void testRandomStrings() throws Exception {
        TestGermanMinimalStemFilter.checkRandomData((Random)TestGermanMinimalStemFilter.random(), (Analyzer)this.analyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new GermanMinimalStemFilter((TokenStream)tokenizer));
            }
        };
        TestGermanMinimalStemFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

