/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.de.GermanNormalizationFilter;

public class TestGermanNormalizationFilter
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String field) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                GermanNormalizationFilter stream = new GermanNormalizationFilter((TokenStream)tokenizer);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
            }
        };
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void testBasicExamples() throws IOException {
        TestGermanNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Schaltfl\u00e4chen", (String)"Schaltflachen");
        TestGermanNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Schaltflaechen", (String)"Schaltflachen");
    }

    public void testUHeuristic() throws IOException {
        TestGermanNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"dauer", (String)"dauer");
    }

    public void testSpecialFolding() throws IOException {
        TestGermanNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"wei\u00dfbier", (String)"weissbier");
    }

    public void testRandomStrings() throws Exception {
        TestGermanNormalizationFilter.checkRandomData((Random)TestGermanNormalizationFilter.random(), (Analyzer)this.analyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new GermanNormalizationFilter((TokenStream)tokenizer));
            }
        };
        TestGermanNormalizationFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

