/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestGermanNormalizationFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testStemming() throws Exception {
        StringReader reader = new StringReader("wei\u00dfbier");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("GermanNormalization", new String[0]).create((TokenStream)stream);
        TestGermanNormalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"weissbier"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestGermanNormalizationFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("GermanNormalization", "bogusArg", "bogusValue"));
        TestGermanNormalizationFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

