/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.el;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestGreekLowerCaseFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testNormalization() throws Exception {
        StringReader reader = new StringReader("\u039c\u03ac\u03ca\u03bf\u03c2 \u039c\u0386\u03aa\u039f\u03a3");
        MockTokenizer stream = TestGreekLowerCaseFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("GreekLowerCase", new String[0]).create((TokenStream)stream);
        TestGreekLowerCaseFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\u03bc\u03b1\u03b9\u03bf\u03c3", "\u03bc\u03b1\u03b9\u03bf\u03c3"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestGreekLowerCaseFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("GreekLowerCase", "bogusArg", "bogusValue"));
        TestGreekLowerCaseFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

