/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.el;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestGreekStemFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testStemming() throws Exception {
        StringReader reader = new StringReader("\u03ac\u03bd\u03b8\u03c1\u03c9\u03c0\u03bf\u03c2");
        MockTokenizer stream = TestGreekStemFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("GreekLowerCase", new String[0]).create((TokenStream)stream);
        stream = this.tokenFilterFactory("GreekStem", new String[0]).create((TokenStream)stream);
        TestGreekStemFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestGreekStemFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("GreekStem", "bogusArg", "bogusValue"));
        TestGreekStemFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

