/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.el;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.el.GreekStemFilter;

public class TestGreekStemmer
extends BaseTokenStreamTestCase {
    private Analyzer a;

    public void setUp() throws Exception {
        super.setUp();
        this.a = new GreekAnalyzer();
    }

    public void tearDown() throws Exception {
        this.a.close();
        super.tearDown();
    }

    public void testMasculineNouns() throws Exception {
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ac\u03bd\u03b8\u03c1\u03c9\u03c0\u03bf\u03c2", (String)"\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03b8\u03c1\u03ce\u03c0\u03bf\u03c5", (String)"\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ac\u03bd\u03b8\u03c1\u03c9\u03c0\u03bf", (String)"\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ac\u03bd\u03b8\u03c1\u03c9\u03c0\u03b5", (String)"\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ac\u03bd\u03b8\u03c1\u03c9\u03c0\u03bf\u03b9", (String)"\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03b8\u03c1\u03ce\u03c0\u03c9\u03bd", (String)"\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03b8\u03c1\u03ce\u03c0\u03bf\u03c5\u03c2", (String)"\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ac\u03bd\u03b8\u03c1\u03c9\u03c0\u03bf\u03b9", (String)"\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03bb\u03ac\u03c4\u03b7\u03c2", (String)"\u03c0\u03b5\u03bb\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03bb\u03ac\u03c4\u03b7", (String)"\u03c0\u03b5\u03bb\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03bb\u03ac\u03c4\u03b5\u03c2", (String)"\u03c0\u03b5\u03bb\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03bb\u03b1\u03c4\u03ce\u03bd", (String)"\u03c0\u03b5\u03bb\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b5\u03bb\u03ad\u03c6\u03b1\u03bd\u03c4\u03b1\u03c2", (String)"\u03b5\u03bb\u03b5\u03c6\u03b1\u03bd\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b5\u03bb\u03ad\u03c6\u03b1\u03bd\u03c4\u03b1", (String)"\u03b5\u03bb\u03b5\u03c6\u03b1\u03bd\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b5\u03bb\u03ad\u03c6\u03b1\u03bd\u03c4\u03b5\u03c2", (String)"\u03b5\u03bb\u03b5\u03c6\u03b1\u03bd\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b5\u03bb\u03b5\u03c6\u03ac\u03bd\u03c4\u03c9\u03bd", (String)"\u03b5\u03bb\u03b5\u03c6\u03b1\u03bd\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03c0\u03b1\u03bc\u03c0\u03ac\u03c2", (String)"\u03bc\u03c0\u03b1\u03bc\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03c0\u03b1\u03bc\u03c0\u03ac", (String)"\u03bc\u03c0\u03b1\u03bc\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03c0\u03b1\u03bc\u03c0\u03ac\u03b4\u03b5\u03c2", (String)"\u03bc\u03c0\u03b1\u03bc\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03c0\u03b1\u03bc\u03c0\u03ac\u03b4\u03c9\u03bd", (String)"\u03bc\u03c0\u03b1\u03bc\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03c0\u03b1\u03ba\u03ac\u03bb\u03b7\u03c2", (String)"\u03bc\u03c0\u03b1\u03ba\u03b1\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03c0\u03b1\u03ba\u03ac\u03bb\u03b7", (String)"\u03bc\u03c0\u03b1\u03ba\u03b1\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03c0\u03b1\u03ba\u03ac\u03bb\u03b7\u03b4\u03b5\u03c2", (String)"\u03bc\u03c0\u03b1\u03ba\u03b1\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03c0\u03b1\u03ba\u03ac\u03bb\u03b7\u03b4\u03c9\u03bd", (String)"\u03bc\u03c0\u03b1\u03ba\u03b1\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03c6\u03ad\u03c2", (String)"\u03ba\u03b1\u03c6");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03c6\u03ad", (String)"\u03ba\u03b1\u03c6");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03c6\u03ad\u03b4\u03b5\u03c2", (String)"\u03ba\u03b1\u03c6");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03c6\u03ad\u03b4\u03c9\u03bd", (String)"\u03ba\u03b1\u03c6");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03ad\u03b1\u03c2", (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03b5");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03ad\u03b1", (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03b5");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03b5\u03af\u03c2", (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03ad\u03c9\u03bd", (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03c0\u03cc\u03c0\u03bb\u03bf\u03c5\u03c2", (String)"\u03b1\u03c0\u03bf\u03c0\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03c0\u03cc\u03c0\u03bb\u03bf\u03c5", (String)"\u03b1\u03c0\u03bf\u03c0\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03c0\u03cc\u03c0\u03bb\u03bf\u03b9", (String)"\u03b1\u03c0\u03bf\u03c0\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03c0\u03cc\u03c0\u03bb\u03c9\u03bd", (String)"\u03b1\u03c0\u03bf\u03c0\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b1\u03c0\u03c0\u03bf\u03cd\u03c2", (String)"\u03c0\u03b1\u03c0\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b1\u03c0\u03c0\u03bf\u03cd", (String)"\u03c0\u03b1\u03c0\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b1\u03c0\u03c0\u03bf\u03cd\u03b4\u03b5\u03c2", (String)"\u03c0\u03b1\u03c0\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b1\u03c0\u03c0\u03bf\u03cd\u03b4\u03c9\u03bd", (String)"\u03c0\u03b1\u03c0\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bb\u03ac\u03c4\u03c1\u03b7\u03c2", (String)"\u03bb\u03b1\u03c4\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bb\u03ac\u03c4\u03c1\u03b7", (String)"\u03bb\u03b1\u03c4\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bb\u03ac\u03c4\u03c1\u03b5\u03b9\u03c2", (String)"\u03bb\u03b1\u03c4\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bb\u03ac\u03c4\u03c1\u03b5\u03c9\u03bd", (String)"\u03bb\u03b1\u03c4\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03ad\u03bb\u03b5\u03ba\u03c5\u03c2", (String)"\u03c0\u03b5\u03bb\u03b5\u03ba");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03ad\u03bb\u03b5\u03ba\u03c5", (String)"\u03c0\u03b5\u03bb\u03b5\u03ba");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03bb\u03ad\u03ba\u03b5\u03b9\u03c2", (String)"\u03c0\u03b5\u03bb\u03b5\u03ba");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03bb\u03ad\u03ba\u03b5\u03c9\u03bd", (String)"\u03c0\u03b5\u03bb\u03b5\u03ba");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03ad\u03bd\u03c4\u03c9\u03c1", (String)"\u03bc\u03b5\u03bd\u03c4\u03c9\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03ad\u03bd\u03c4\u03bf\u03c1\u03bf\u03c2", (String)"\u03bc\u03b5\u03bd\u03c4\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03ad\u03bd\u03c4\u03bf\u03c1\u03b1", (String)"\u03bc\u03b5\u03bd\u03c4\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03ad\u03bd\u03c4\u03bf\u03c1\u03b5\u03c2", (String)"\u03bc\u03b5\u03bd\u03c4\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03b5\u03bd\u03c4\u03cc\u03c1\u03c9\u03bd", (String)"\u03bc\u03b5\u03bd\u03c4\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03b3\u03ce\u03bd\u03b1\u03c2", (String)"\u03b1\u03b3\u03c9\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03b3\u03ce\u03bd\u03bf\u03c2", (String)"\u03b1\u03b3\u03c9\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03b3\u03ce\u03bd\u03b1", (String)"\u03b1\u03b3\u03c9\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03b3\u03ce\u03bd\u03b1", (String)"\u03b1\u03b3\u03c9\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03b3\u03ce\u03bd\u03b5\u03c2", (String)"\u03b1\u03b3\u03c9\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03b3\u03ce\u03bd\u03c9\u03bd", (String)"\u03b1\u03b3\u03c9\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03ad\u03c1\u03b1\u03c2", (String)"\u03b1\u03b5\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03ad\u03c1\u03b1", (String)"\u03b1\u03b5\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03ad\u03c1\u03b7\u03b4\u03b5\u03c2", (String)"\u03b1\u03b5\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03ad\u03c1\u03b7\u03b4\u03c9\u03bd", (String)"\u03b1\u03b5\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03cc\u03b7\u03c2", (String)"\u03b3\u03bf");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03cc\u03b7", (String)"\u03b3\u03bf\u03b7");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03cc\u03b7\u03c4\u03b5\u03c2", (String)"\u03b3\u03bf\u03b7\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03bf\u03ae\u03c4\u03c9\u03bd", (String)"\u03b3\u03bf\u03b7\u03c4");
    }

    public void testFeminineNouns() throws Exception {
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03ac", (String)"\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03ac\u03c2", (String)"\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03ad\u03c2", (String)"\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03ce\u03bd", (String)"\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03b3\u03b5\u03bb\u03ac\u03b4\u03b1", (String)"\u03b1\u03b3\u03b5\u03bb\u03b1\u03b4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03b3\u03b5\u03bb\u03ac\u03b4\u03b1\u03c2", (String)"\u03b1\u03b3\u03b5\u03bb\u03b1\u03b4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03b3\u03b5\u03bb\u03ac\u03b4\u03b5\u03c2", (String)"\u03b1\u03b3\u03b5\u03bb\u03b1\u03b4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03b3\u03b5\u03bb\u03ac\u03b4\u03c9\u03bd", (String)"\u03b1\u03b3\u03b5\u03bb\u03b1\u03b4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b6\u03ac\u03c7\u03b1\u03c1\u03b7", (String)"\u03b6\u03b1\u03c7\u03b1\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b6\u03ac\u03c7\u03b1\u03c1\u03b7\u03c2", (String)"\u03b6\u03b1\u03c7\u03b1\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b6\u03ac\u03c7\u03b1\u03c1\u03b5\u03c2", (String)"\u03b6\u03b1\u03c7\u03b1\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b6\u03b1\u03c7\u03ac\u03c1\u03b5\u03c9\u03bd", (String)"\u03b6\u03b1\u03c7\u03b1\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c4\u03b7\u03bb\u03b5\u03cc\u03c1\u03b1\u03c3\u03b7", (String)"\u03c4\u03b7\u03bb\u03b5\u03bf\u03c1\u03b1\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c4\u03b7\u03bb\u03b5\u03cc\u03c1\u03b1\u03c3\u03b7\u03c2", (String)"\u03c4\u03b7\u03bb\u03b5\u03bf\u03c1\u03b1\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c4\u03b7\u03bb\u03b5\u03bf\u03c1\u03ac\u03c3\u03b5\u03b9\u03c2", (String)"\u03c4\u03b7\u03bb\u03b5\u03bf\u03c1\u03b1\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c4\u03b7\u03bb\u03b5\u03bf\u03c1\u03ac\u03c3\u03b5\u03c9\u03bd", (String)"\u03c4\u03b7\u03bb\u03b5\u03bf\u03c1\u03b1\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03b1\u03bc\u03ac", (String)"\u03bc\u03b1\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03b1\u03bc\u03ac\u03c2", (String)"\u03bc\u03b1\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03b1\u03bc\u03ac\u03b4\u03b5\u03c2", (String)"\u03bc\u03b1\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03b1\u03bc\u03ac\u03b4\u03c9\u03bd", (String)"\u03bc\u03b1\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bb\u03b5\u03c9\u03c6\u03cc\u03c1\u03bf\u03c2", (String)"\u03bb\u03b5\u03c9\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bb\u03b5\u03c9\u03c6\u03cc\u03c1\u03bf\u03c5", (String)"\u03bb\u03b5\u03c9\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bb\u03b5\u03c9\u03c6\u03cc\u03c1\u03bf", (String)"\u03bb\u03b5\u03c9\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bb\u03b5\u03c9\u03c6\u03cc\u03c1\u03b5", (String)"\u03bb\u03b5\u03c9\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bb\u03b5\u03c9\u03c6\u03cc\u03c1\u03bf\u03b9", (String)"\u03bb\u03b5\u03c9\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bb\u03b5\u03c9\u03c6\u03cc\u03c1\u03c9\u03bd", (String)"\u03bb\u03b5\u03c9\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bb\u03b5\u03c9\u03c6\u03cc\u03c1\u03bf\u03c5\u03c2", (String)"\u03bb\u03b5\u03c9\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bb\u03b5\u03c0\u03bf\u03cd", (String)"\u03b1\u03bb\u03b5\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bb\u03b5\u03c0\u03bf\u03cd\u03c2", (String)"\u03b1\u03bb\u03b5\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bb\u03b5\u03c0\u03bf\u03cd\u03b4\u03b5\u03c2", (String)"\u03b1\u03bb\u03b5\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bb\u03b5\u03c0\u03bf\u03cd\u03b4\u03c9\u03bd", (String)"\u03b1\u03bb\u03b5\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03ad\u03b1\u03c2", (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03b5");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03ad\u03c9\u03c2", (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03ad\u03b1", (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03b5");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03b5\u03af\u03c2", (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03ad\u03c9\u03bd", (String)"\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4");
    }

    public void testNeuterNouns() throws Exception {
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03b9\u03b2\u03bb\u03af\u03bf", (String)"\u03b2\u03b9\u03b2\u03bb\u03b9");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03b9\u03b2\u03bb\u03af\u03bf\u03c5", (String)"\u03b2\u03b9\u03b2\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03b9\u03b2\u03bb\u03af\u03b1", (String)"\u03b2\u03b9\u03b2\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03b9\u03b2\u03bb\u03af\u03c9\u03bd", (String)"\u03b2\u03b9\u03b2\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03bf\u03c5\u03bb\u03af", (String)"\u03c0\u03bf\u03c5\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03bf\u03c5\u03bb\u03b9\u03bf\u03cd", (String)"\u03c0\u03bf\u03c5\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03bf\u03c5\u03bb\u03b9\u03ac", (String)"\u03c0\u03bf\u03c5\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03bf\u03c5\u03bb\u03b9\u03ce\u03bd", (String)"\u03c0\u03bf\u03c5\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03c1\u03cc\u03b2\u03bb\u03b7\u03bc\u03b1", (String)"\u03c0\u03c1\u03bf\u03b2\u03bb\u03b7\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03c1\u03bf\u03b2\u03bb\u03ae\u03bc\u03b1\u03c4\u03bf\u03c2", (String)"\u03c0\u03c1\u03bf\u03b2\u03bb\u03b7\u03bc\u03b1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03c1\u03bf\u03b2\u03bb\u03ae\u03bc\u03b1\u03c4\u03b1", (String)"\u03c0\u03c1\u03bf\u03b2\u03bb\u03b7\u03bc\u03b1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03c1\u03bf\u03b2\u03bb\u03b7\u03bc\u03ac\u03c4\u03c9\u03bd", (String)"\u03c0\u03c1\u03bf\u03b2\u03bb\u03b7\u03bc\u03b1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03ad\u03bb\u03b1\u03b3\u03bf\u03c2", (String)"\u03c0\u03b5\u03bb\u03b1\u03b3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03bb\u03ac\u03b3\u03bf\u03c5\u03c2", (String)"\u03c0\u03b5\u03bb\u03b1\u03b3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03bb\u03ac\u03b3\u03b7", (String)"\u03c0\u03b5\u03bb\u03b1\u03b3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03bb\u03ac\u03b3\u03c9\u03bd", (String)"\u03c0\u03b5\u03bb\u03b1\u03b3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03b5\u03b3\u03bf\u03bd\u03cc\u03c2", (String)"\u03b3\u03b5\u03b3\u03bf\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03b5\u03b3\u03bf\u03bd\u03cc\u03c4\u03bf\u03c2", (String)"\u03b3\u03b5\u03b3\u03bf\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03b5\u03b3\u03bf\u03bd\u03cc\u03c4\u03b1", (String)"\u03b3\u03b5\u03b3\u03bf\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03b5\u03b3\u03bf\u03bd\u03cc\u03c4\u03c9\u03bd", (String)"\u03b3\u03b5\u03b3\u03bf\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03c1\u03ac\u03b4\u03c5", (String)"\u03b2\u03c1\u03b1\u03b4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03c1\u03ac\u03b4\u03b9", (String)"\u03b2\u03c1\u03b1\u03b4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03c1\u03b1\u03b4\u03b9\u03bf\u03cd", (String)"\u03b2\u03c1\u03b1\u03b4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03c1\u03ac\u03b4\u03b9\u03b1", (String)"\u03b2\u03c1\u03b1\u03b4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03c1\u03b1\u03b4\u03b9\u03ce\u03bd", (String)"\u03b2\u03c1\u03b1\u03b4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b4\u03cc\u03c1\u03c5", (String)"\u03b4\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b4\u03cc\u03c1\u03b1\u03c4\u03bf\u03c2", (String)"\u03b4\u03bf\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b4\u03cc\u03c1\u03b1\u03c4\u03b1", (String)"\u03b4\u03bf\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b4\u03bf\u03c1\u03ac\u03c4\u03c9\u03bd", (String)"\u03b4\u03bf\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03ad\u03b1\u03c2", (String)"\u03ba\u03c1\u03b5");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03ad\u03b1\u03c4\u03bf\u03c2", (String)"\u03ba\u03c1\u03b5");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03ad\u03b1\u03c4\u03b1", (String)"\u03ba\u03c1\u03b5");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b5\u03ac\u03c4\u03c9\u03bd", (String)"\u03ba\u03c1\u03b5");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bb\u03c5\u03ba\u03cc\u03c6\u03c9\u03c2", (String)"\u03bb\u03c5\u03ba\u03bf\u03c6\u03c9");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bb\u03c5\u03ba\u03cc\u03c6\u03c9\u03c4\u03bf\u03c2", (String)"\u03bb\u03c5\u03ba\u03bf\u03c6\u03c9");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bb\u03c5\u03ba\u03cc\u03c6\u03c9\u03c4\u03b1", (String)"\u03bb\u03c5\u03ba\u03bf\u03c6\u03c9");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bb\u03c5\u03ba\u03bf\u03c6\u03ce\u03c4\u03c9\u03bd", (String)"\u03bb\u03c5\u03ba\u03bf\u03c6\u03c9");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03ad\u03c3\u03bf\u03bd", (String)"\u03bc\u03b5\u03c3\u03bf\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03ad\u03c3\u03bf\u03c5", (String)"\u03bc\u03b5\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03ad\u03c3\u03b1", (String)"\u03bc\u03b5\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bc\u03ad\u03c3\u03c9\u03bd", (String)"\u03bc\u03b5\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b5\u03bd\u03b4\u03b9\u03b1\u03c6\u03ad\u03c1\u03bf\u03bd", (String)"\u03b5\u03bd\u03b4\u03b9\u03b1\u03c6\u03b5\u03c1\u03bf\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b5\u03bd\u03b4\u03b9\u03b1\u03c6\u03ad\u03c1\u03bf\u03bd\u03c4\u03bf\u03c2", (String)"\u03b5\u03bd\u03b4\u03b9\u03b1\u03c6\u03b5\u03c1\u03bf\u03bd\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b5\u03bd\u03b4\u03b9\u03b1\u03c6\u03ad\u03c1\u03bf\u03bd\u03c4\u03b1", (String)"\u03b5\u03bd\u03b4\u03b9\u03b1\u03c6\u03b5\u03c1\u03bf\u03bd\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b5\u03bd\u03b4\u03b9\u03b1\u03c6\u03b5\u03c1\u03cc\u03bd\u03c4\u03c9\u03bd", (String)"\u03b5\u03bd\u03b4\u03b9\u03b1\u03c6\u03b5\u03c1\u03bf\u03bd\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03b1\u03ba\u03bf\u03b9\u03bd\u03c9\u03b8\u03ad\u03bd", (String)"\u03b1\u03bd\u03b1\u03ba\u03bf\u03b9\u03bd\u03c9\u03b8\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03b1\u03ba\u03bf\u03b9\u03bd\u03c9\u03b8\u03ad\u03bd\u03c4\u03bf\u03c2", (String)"\u03b1\u03bd\u03b1\u03ba\u03bf\u03b9\u03bd\u03c9\u03b8\u03b5\u03bd\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03b1\u03ba\u03bf\u03b9\u03bd\u03c9\u03b8\u03ad\u03bd\u03c4\u03b1", (String)"\u03b1\u03bd\u03b1\u03ba\u03bf\u03b9\u03bd\u03c9\u03b8\u03b5\u03bd\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03b1\u03ba\u03bf\u03b9\u03bd\u03c9\u03b8\u03ad\u03bd\u03c4\u03c9\u03bd", (String)"\u03b1\u03bd\u03b1\u03ba\u03bf\u03b9\u03bd\u03c9\u03b8\u03b5\u03bd\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03cd\u03bc\u03c0\u03b1\u03bd", (String)"\u03c3\u03c5\u03bc\u03c0");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03cd\u03bc\u03c0\u03b1\u03bd\u03c4\u03bf\u03c2", (String)"\u03c3\u03c5\u03bc\u03c0\u03b1\u03bd\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03cd\u03bc\u03c0\u03b1\u03bd\u03c4\u03b1", (String)"\u03c3\u03c5\u03bc\u03c0\u03b1\u03bd\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03c5\u03bc\u03c0\u03ac\u03bd\u03c4\u03c9\u03bd", (String)"\u03c3\u03c5\u03bc\u03c0\u03b1\u03bd\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03ac\u03bb\u03b1", (String)"\u03b3\u03b1\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03ac\u03bb\u03b1\u03ba\u03c4\u03bf\u03c2", (String)"\u03b3\u03b1\u03bb\u03b1\u03ba\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03ac\u03bb\u03b1\u03c4\u03b1", (String)"\u03b3\u03b1\u03bb\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b3\u03b1\u03bb\u03ac\u03ba\u03c4\u03c9\u03bd", (String)"\u03b3\u03b1\u03bb\u03b1\u03ba\u03c4");
    }

    public void testAdjectives() throws Exception {
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03c5\u03bd\u03b5\u03c7\u03ae\u03c2", (String)"\u03c3\u03c5\u03bd\u03b5\u03c7");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03c5\u03bd\u03b5\u03c7\u03bf\u03cd\u03c2", (String)"\u03c3\u03c5\u03bd\u03b5\u03c7");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03c5\u03bd\u03b5\u03c7\u03ae", (String)"\u03c3\u03c5\u03bd\u03b5\u03c7");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03c5\u03bd\u03b5\u03c7\u03ce\u03bd", (String)"\u03c3\u03c5\u03bd\u03b5\u03c7");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03c5\u03bd\u03b5\u03c7\u03b5\u03af\u03c2", (String)"\u03c3\u03c5\u03bd\u03b5\u03c7");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03c5\u03bd\u03b5\u03c7\u03ad\u03c2", (String)"\u03c3\u03c5\u03bd\u03b5\u03c7");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03c5\u03bd\u03ae\u03b8\u03b7\u03c2", (String)"\u03c3\u03c5\u03bd\u03b7\u03b8");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03c5\u03bd\u03ae\u03b8\u03bf\u03c5\u03c2", (String)"\u03c3\u03c5\u03bd\u03b7\u03b8");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03c5\u03bd\u03ae\u03b8\u03b7", (String)"\u03c3\u03c5\u03bd\u03b7\u03b8");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03c5\u03bd\u03ae\u03b8\u03b5\u03b9\u03c2", (String)"\u03c3\u03c5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03c5\u03bd\u03ae\u03b8\u03c9\u03bd", (String)"\u03c3\u03c5\u03bd\u03b7\u03b8");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c3\u03cd\u03bd\u03b7\u03b8\u03b5\u03c2", (String)"\u03c3\u03c5\u03bd\u03b7\u03b8");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03b1\u03b8\u03cd\u03c2", (String)"\u03b2\u03b1\u03b8");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03b1\u03b8\u03ad\u03bf\u03c2", (String)"\u03b2\u03b1\u03b8\u03b5");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03b1\u03b8\u03cd", (String)"\u03b2\u03b1\u03b8");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03b1\u03b8\u03b5\u03af\u03c2", (String)"\u03b2\u03b1\u03b8");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03b1\u03b8\u03ad\u03c9\u03bd", (String)"\u03b2\u03b1\u03b8");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03b1\u03b8\u03b9\u03ac", (String)"\u03b2\u03b1\u03b8");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03b1\u03b8\u03b9\u03ac\u03c2", (String)"\u03b2\u03b1\u03b8\u03b9");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03b1\u03b8\u03b9\u03ad\u03c2", (String)"\u03b2\u03b1\u03b8\u03b9");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03b1\u03b8\u03b9\u03ce\u03bd", (String)"\u03b2\u03b1\u03b8");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b2\u03b1\u03b8\u03ad\u03b1", (String)"\u03b2\u03b1\u03b8\u03b5");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c8\u03b7\u03bb\u03cc\u03c2", (String)"\u03c8\u03b7\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c8\u03b7\u03bb\u03cc\u03c4\u03b5\u03c1\u03bf\u03c2", (String)"\u03c8\u03b7\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c8\u03b7\u03bb\u03cc\u03c4\u03b1\u03c4\u03bf\u03c2", (String)"\u03c8\u03b7\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c9\u03c1\u03b1\u03af\u03bf\u03c2", (String)"\u03c9\u03c1\u03b1\u03b9");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c9\u03c1\u03b1\u03b9\u03cc\u03c4\u03b5\u03c1\u03bf\u03c2", (String)"\u03c9\u03c1\u03b1\u03b9");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c9\u03c1\u03b1\u03b9\u03cc\u03c4\u03b1\u03c4\u03bf\u03c2", (String)"\u03c9\u03c1\u03b1\u03b9");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b5\u03c0\u03b9\u03b5\u03b9\u03ba\u03ae\u03c2", (String)"\u03b5\u03c0\u03b9\u03b5\u03b9\u03ba");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b5\u03c0\u03b9\u03b5\u03b9\u03ba\u03ad\u03c3\u03c4\u03b5\u03c1\u03bf\u03c2", (String)"\u03b5\u03c0\u03b9\u03b5\u03b9\u03ba");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b5\u03c0\u03b9\u03b5\u03b9\u03ba\u03ad\u03c3\u03c4\u03b1\u03c4\u03bf\u03c2", (String)"\u03b5\u03c0\u03b9\u03b5\u03b9\u03ba");
    }

    public void testVerbs() throws Exception {
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bf\u03c1\u03af\u03b6\u03c9", (String)"\u03bf\u03c1\u03b9\u03b6");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03cc\u03c1\u03b9\u03b6\u03b1", (String)"\u03bf\u03c1\u03b9\u03b6");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03cc\u03c1\u03b9\u03b6\u03b5", (String)"\u03bf\u03c1\u03b9\u03b6");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bf\u03c1\u03af\u03b6\u03bf\u03bd\u03c4\u03b1\u03c2", (String)"\u03bf\u03c1\u03b9\u03b6");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bf\u03c1\u03af\u03b6\u03bf\u03bc\u03b1\u03b9", (String)"\u03bf\u03c1\u03b9\u03b6");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bf\u03c1\u03b9\u03b6\u03cc\u03bc\u03bf\u03c5\u03bd", (String)"\u03bf\u03c1\u03b9\u03b6");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bf\u03c1\u03af\u03b6\u03b5\u03c3\u03b1\u03b9", (String)"\u03bf\u03c1\u03b9\u03b6");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03cc\u03c1\u03b9\u03c3\u03b1", (String)"\u03bf\u03c1\u03b9\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bf\u03c1\u03af\u03c3\u03c9", (String)"\u03bf\u03c1\u03b9\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03cc\u03c1\u03b9\u03c3\u03b5", (String)"\u03bf\u03c1\u03b9\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bf\u03c1\u03af\u03c3\u03b5\u03b9", (String)"\u03bf\u03c1\u03b9\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bf\u03c1\u03af\u03c3\u03c4\u03b7\u03ba\u03b1", (String)"\u03bf\u03c1\u03b9\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bf\u03c1\u03b9\u03c3\u03c4\u03ce", (String)"\u03bf\u03c1\u03b9\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bf\u03c1\u03b9\u03c3\u03c4\u03b5\u03af\u03c2", (String)"\u03bf\u03c1\u03b9\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bf\u03c1\u03b9\u03c3\u03c4\u03b5\u03af", (String)"\u03bf\u03c1\u03b9\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bf\u03c1\u03b9\u03c3\u03bc\u03ad\u03bd\u03bf", (String)"\u03bf\u03c1\u03b9\u03c3\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bf\u03c1\u03b9\u03c3\u03bc\u03ad\u03bd\u03b7", (String)"\u03bf\u03c1\u03b9\u03c3\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03bf\u03c1\u03b9\u03c3\u03bc\u03ad\u03bd\u03bf\u03c2", (String)"\u03bf\u03c1\u03b9\u03c3\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03bf\u03af\u03b3\u03c9", (String)"\u03b1\u03bd\u03bf\u03b9\u03b3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ac\u03bd\u03bf\u03b9\u03b3\u03b1", (String)"\u03b1\u03bd\u03bf\u03b9\u03b3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ac\u03bd\u03bf\u03b9\u03b3\u03b5", (String)"\u03b1\u03bd\u03bf\u03b9\u03b3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03bf\u03af\u03b3\u03bf\u03bd\u03c4\u03b1\u03c2", (String)"\u03b1\u03bd\u03bf\u03b9\u03b3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03bf\u03af\u03b3\u03bf\u03bc\u03b1\u03b9", (String)"\u03b1\u03bd\u03bf\u03b9\u03b3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03bf\u03b9\u03b3\u03cc\u03bc\u03bf\u03c5\u03bd", (String)"\u03b1\u03bd\u03bf\u03b9\u03b3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ac\u03bd\u03bf\u03b9\u03be\u03b1", (String)"\u03b1\u03bd\u03bf\u03b9\u03be");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03bf\u03af\u03be\u03c9", (String)"\u03b1\u03bd\u03bf\u03b9\u03be");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ac\u03bd\u03bf\u03b9\u03be\u03b5", (String)"\u03b1\u03bd\u03bf\u03b9\u03be");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03bf\u03af\u03be\u03b5\u03b9", (String)"\u03b1\u03bd\u03bf\u03b9\u03be");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03bf\u03af\u03c7\u03c4\u03b7\u03ba\u03b1", (String)"\u03b1\u03bd\u03bf\u03b9\u03c7\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03bf\u03b9\u03c7\u03c4\u03ce", (String)"\u03b1\u03bd\u03bf\u03b9\u03c7\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03bf\u03af\u03c7\u03c4\u03b7\u03ba\u03b1", (String)"\u03b1\u03bd\u03bf\u03b9\u03c7\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03bf\u03b9\u03c7\u03c4\u03b5\u03af\u03c2", (String)"\u03b1\u03bd\u03bf\u03b9\u03c7\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03bf\u03b9\u03c7\u03c4\u03b5\u03af", (String)"\u03b1\u03bd\u03bf\u03b9\u03c7\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03bd\u03bf\u03af\u03be\u03bf\u03c5", (String)"\u03b1\u03bd\u03bf\u03b9\u03be");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c1\u03bd\u03ce", (String)"\u03c0\u03b5\u03c1\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c1\u03bd\u03ac\u03c9", (String)"\u03c0\u03b5\u03c1\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c1\u03bd\u03bf\u03cd\u03c3\u03b1", (String)"\u03c0\u03b5\u03c1\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03ad\u03c1\u03bd\u03b1\u03b3\u03b1", (String)"\u03c0\u03b5\u03c1\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03ad\u03c1\u03bd\u03b1", (String)"\u03c0\u03b5\u03c1\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c1\u03bd\u03ce\u03bd\u03c4\u03b1\u03c2", (String)"\u03c0\u03b5\u03c1\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03ad\u03c1\u03b1\u03c3\u03b1", (String)"\u03c0\u03b5\u03c1\u03b1\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c1\u03ac\u03c3\u03c9", (String)"\u03c0\u03b5\u03c1\u03b1\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03ad\u03c1\u03b1\u03c3\u03b5", (String)"\u03c0\u03b5\u03c1\u03b1\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c1\u03ac\u03c3\u03b5\u03b9", (String)"\u03c0\u03b5\u03c1\u03b1\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c1\u03bd\u03b9\u03ad\u03bc\u03b1\u03b9", (String)"\u03c0\u03b5\u03c1\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c1\u03bd\u03b9\u03cc\u03bc\u03bf\u03c5\u03bd", (String)"\u03c0\u03b5\u03c1\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c1\u03ac\u03c3\u03c4\u03b7\u03ba\u03b1", (String)"\u03c0\u03b5\u03c1\u03b1\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c1\u03b1\u03c3\u03c4\u03ce", (String)"\u03c0\u03b5\u03c1\u03b1\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c1\u03b1\u03c3\u03c4\u03b5\u03af\u03c2", (String)"\u03c0\u03b5\u03c1\u03b1\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c1\u03b1\u03c3\u03c4\u03b5\u03af", (String)"\u03c0\u03b5\u03c1\u03b1\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c1\u03b1\u03c3\u03bc\u03ad\u03bd\u03bf", (String)"\u03c0\u03b5\u03c1\u03b1\u03c3\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c1\u03b1\u03c3\u03bc\u03ad\u03bd\u03b7", (String)"\u03c0\u03b5\u03c1\u03b1\u03c3\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c1\u03b1\u03c3\u03bc\u03ad\u03bd\u03bf\u03c2", (String)"\u03c0\u03b5\u03c1\u03b1\u03c3\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c4\u03ce", (String)"\u03c0\u03b5\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c4\u03ac\u03c9", (String)"\u03c0\u03b5\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c4\u03bf\u03cd\u03c3\u03b1", (String)"\u03c0\u03b5\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03ad\u03c4\u03b1\u03b3\u03b1", (String)"\u03c0\u03b5\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03ad\u03c4\u03b1", (String)"\u03c0\u03b5\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c4\u03ce\u03bd\u03c4\u03b1\u03c2", (String)"\u03c0\u03b5\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c4\u03b9\u03ad\u03bc\u03b1\u03b9", (String)"\u03c0\u03b5\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c4\u03b9\u03cc\u03bc\u03bf\u03c5\u03bd", (String)"\u03c0\u03b5\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03ad\u03c4\u03b1\u03be\u03b1", (String)"\u03c0\u03b5\u03c4\u03b1\u03be");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c4\u03ac\u03be\u03c9", (String)"\u03c0\u03b5\u03c4\u03b1\u03be");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03ad\u03c4\u03b1\u03be\u03b5", (String)"\u03c0\u03b5\u03c4\u03b1\u03be");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c4\u03ac\u03be\u03b5\u03b9", (String)"\u03c0\u03b5\u03c4\u03b1\u03be");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c4\u03ac\u03c7\u03c4\u03b7\u03ba\u03b1", (String)"\u03c0\u03b5\u03c4\u03b1\u03c7\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c4\u03b1\u03c7\u03c4\u03ce", (String)"\u03c0\u03b5\u03c4\u03b1\u03c7\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c4\u03b1\u03c7\u03c4\u03b5\u03af\u03c2", (String)"\u03c0\u03b5\u03c4\u03b1\u03c7\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c4\u03b1\u03c7\u03c4\u03b5\u03af", (String)"\u03c0\u03b5\u03c4\u03b1\u03c7\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c4\u03b1\u03bc\u03ad\u03bd\u03bf", (String)"\u03c0\u03b5\u03c4\u03b1\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c4\u03b1\u03bc\u03ad\u03bd\u03b7", (String)"\u03c0\u03b5\u03c4\u03b1\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c0\u03b5\u03c4\u03b1\u03bc\u03ad\u03bd\u03bf\u03c2", (String)"\u03c0\u03b5\u03c4\u03b1\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03bb\u03ce", (String)"\u03ba\u03b1\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03bb\u03bf\u03cd\u03c3\u03b1", (String)"\u03ba\u03b1\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03bb\u03b5\u03af\u03c2", (String)"\u03ba\u03b1\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03bb\u03ce\u03bd\u03c4\u03b1\u03c2", (String)"\u03ba\u03b1\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03bb\u03bf\u03cd\u03bc\u03b1\u03b9", (String)"\u03ba\u03b1\u03bb");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03bb\u03bf\u03cd\u03bc\u03bf\u03c5\u03bd", (String)"\u03ba\u03b1\u03bb\u03bf\u03c5\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03bb\u03b5\u03af\u03c3\u03b1\u03b9", (String)"\u03ba\u03b1\u03bb\u03b5\u03b9\u03c3\u03b1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03bb\u03ad\u03c3\u03c4\u03b7\u03ba\u03b1", (String)"\u03ba\u03b1\u03bb\u03b5\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03bb\u03b5\u03c3\u03c4\u03ce", (String)"\u03ba\u03b1\u03bb\u03b5\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03bb\u03b5\u03c3\u03c4\u03b5\u03af\u03c2", (String)"\u03ba\u03b1\u03bb\u03b5\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03bb\u03b5\u03c3\u03c4\u03b5\u03af", (String)"\u03ba\u03b1\u03bb\u03b5\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03bb\u03b5\u03c3\u03bc\u03ad\u03bd\u03bf", (String)"\u03ba\u03b1\u03bb\u03b5\u03c3\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03bb\u03b5\u03c3\u03bc\u03ad\u03bd\u03b7", (String)"\u03ba\u03b1\u03bb\u03b5\u03c3\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03bb\u03b5\u03c3\u03bc\u03ad\u03bd\u03bf\u03c2", (String)"\u03ba\u03b1\u03bb\u03b5\u03c3\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03ce", (String)"\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03ac\u03c9", (String)"\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03bf\u03cd\u03c3\u03b1", (String)"\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03cc\u03c1\u03b1\u03b3\u03b1", (String)"\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03cc\u03c1\u03b1", (String)"\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03ce\u03bd\u03c4\u03b1\u03c2", (String)"\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03b9\u03ad\u03bc\u03b1\u03b9", (String)"\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03b9\u03cc\u03bc\u03bf\u03c5\u03bd", (String)"\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03b9\u03ad\u03c3\u03b1\u03b9", (String)"\u03c6\u03bf\u03c1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03cc\u03c1\u03b5\u03c3\u03b1", (String)"\u03c6\u03bf\u03c1\u03b5\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03ad\u03c3\u03c9", (String)"\u03c6\u03bf\u03c1\u03b5\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03cc\u03c1\u03b5\u03c3\u03b5", (String)"\u03c6\u03bf\u03c1\u03b5\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03ad\u03c3\u03b5\u03b9", (String)"\u03c6\u03bf\u03c1\u03b5\u03c3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03ad\u03b8\u03b7\u03ba\u03b1", (String)"\u03c6\u03bf\u03c1\u03b5\u03b8");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03b5\u03b8\u03ce", (String)"\u03c6\u03bf\u03c1\u03b5\u03b8");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03b5\u03b8\u03b5\u03af\u03c2", (String)"\u03c6\u03bf\u03c1\u03b5\u03b8");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03b5\u03b8\u03b5\u03af", (String)"\u03c6\u03bf\u03c1\u03b5\u03b8");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03b5\u03bc\u03ad\u03bd\u03bf", (String)"\u03c6\u03bf\u03c1\u03b5\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03b5\u03bc\u03ad\u03bd\u03b7", (String)"\u03c6\u03bf\u03c1\u03b5\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c6\u03bf\u03c1\u03b5\u03bc\u03ad\u03bd\u03bf\u03c2", (String)"\u03c6\u03bf\u03c1\u03b5\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03ce", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03ac\u03c9", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03bf\u03cd\u03c3\u03b1", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03ac\u03c4\u03b1\u03b3\u03b1", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03ac\u03c4\u03b1", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03ce\u03bd\u03c4\u03b1\u03c2", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03ac\u03c4\u03b7\u03c3\u03b1", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03ae\u03c3\u03c9", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03ac\u03c4\u03b7\u03c3\u03b5", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03ae\u03c3\u03b5\u03b9", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03bf\u03cd\u03bc\u03b1\u03b9", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03b9\u03ad\u03bc\u03b1\u03b9", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03bf\u03cd\u03bc\u03bf\u03c5\u03bd", (String)"\u03ba\u03c1\u03b1\u03c4\u03bf\u03c5\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03b9\u03cc\u03bc\u03bf\u03c5\u03bd", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03b5\u03af\u03c3\u03b1\u03b9", (String)"\u03ba\u03c1\u03b1\u03c4\u03b5\u03b9\u03c3\u03b1");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03ae\u03b8\u03b7\u03ba\u03b1", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03b7\u03b8\u03ce", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03b7\u03b8\u03b5\u03af\u03c2", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03b7\u03b8\u03b5\u03af", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03ae\u03c3\u03bf\u03c5", (String)"\u03ba\u03c1\u03b1\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03b7\u03bc\u03ad\u03bd\u03bf", (String)"\u03ba\u03c1\u03b1\u03c4\u03b7\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03b7\u03bc\u03ad\u03bd\u03b7", (String)"\u03ba\u03c1\u03b1\u03c4\u03b7\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03c1\u03b1\u03c4\u03b7\u03bc\u03ad\u03bd\u03bf\u03c2", (String)"\u03ba\u03c1\u03b1\u03c4\u03b7\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03bf\u03b9\u03bc\u03ac\u03bc\u03b1\u03b9", (String)"\u03ba\u03bf\u03b9\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03bf\u03b9\u03bc\u03cc\u03bc\u03bf\u03c5\u03bd", (String)"\u03ba\u03bf\u03b9\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03bf\u03b9\u03bc\u03ac\u03c3\u03b1\u03b9", (String)"\u03ba\u03bf\u03b9\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03bf\u03b9\u03bc\u03ae\u03b8\u03b7\u03ba\u03b1", (String)"\u03ba\u03bf\u03b9\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03bf\u03b9\u03bc\u03b7\u03b8\u03ce", (String)"\u03ba\u03bf\u03b9\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03bf\u03b9\u03bc\u03ae\u03c3\u03bf\u03c5", (String)"\u03ba\u03bf\u03b9\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03bf\u03b9\u03bc\u03b7\u03b8\u03b5\u03af", (String)"\u03ba\u03bf\u03b9\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03bf\u03b9\u03bc\u03b9\u03c3\u03bc\u03ad\u03bd\u03bf", (String)"\u03ba\u03bf\u03b9\u03bc\u03b9\u03c3\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03bf\u03b9\u03bc\u03b9\u03c3\u03bc\u03ad\u03bd\u03b7", (String)"\u03ba\u03bf\u03b9\u03bc\u03b9\u03c3\u03bc\u03b5\u03bd");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03bf\u03b9\u03bc\u03b9\u03c3\u03bc\u03ad\u03bd\u03bf\u03c2", (String)"\u03ba\u03bf\u03b9\u03bc\u03b9\u03c3\u03bc\u03b5\u03bd");
    }

    public void testExceptions() throws Exception {
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4\u03ce\u03c4\u03b1", (String)"\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4\u03ce\u03c4\u03bf\u03c2", (String)"\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4\u03ce\u03c2", (String)"\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4\u03ce\u03c4\u03c9\u03bd", (String)"\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c7\u03bf\u03c5\u03bc\u03b5", (String)"\u03c7\u03bf\u03c5\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c7\u03bf\u03c5\u03bc", (String)"\u03c7\u03bf\u03c5\u03bc");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c5\u03c0\u03bf\u03c4\u03b1\u03b3\u03b5\u03c3", (String)"\u03c5\u03c0\u03bf\u03c4\u03b1\u03b3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03c5\u03c0\u03bf\u03c4\u03b1\u03b3", (String)"\u03c5\u03c0\u03bf\u03c4\u03b1\u03b3");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b5\u03bc\u03b5\u03c4\u03b5", (String)"\u03b5\u03bc\u03b5\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b5\u03bc\u03b5\u03c4", (String)"\u03b5\u03bc\u03b5\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03c1\u03c7\u03bf\u03bd\u03c4\u03b1\u03c3", (String)"\u03b1\u03c1\u03c7\u03bf\u03bd\u03c4");
        TestGreekStemmer.checkOneTerm((Analyzer)this.a, (String)"\u03b1\u03c1\u03c7\u03bf\u03bd\u03c4\u03c9\u03bd", (String)"\u03b1\u03c1\u03c7\u03bf\u03bd\u03c4");
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new GreekStemFilter((TokenStream)tokenizer));
            }
        };
        TestGreekStemmer.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

