/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.en;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.en.EnglishAnalyzer;

public class TestEnglishAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new EnglishAnalyzer().close();
    }

    public void testBasics() throws IOException {
        EnglishAnalyzer a = new EnglishAnalyzer();
        TestEnglishAnalyzer.checkOneTerm((Analyzer)a, (String)"books", (String)"book");
        TestEnglishAnalyzer.checkOneTerm((Analyzer)a, (String)"book", (String)"book");
        TestEnglishAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"the", (String[])new String[0]);
        TestEnglishAnalyzer.checkOneTerm((Analyzer)a, (String)"steven's", (String)"steven");
        TestEnglishAnalyzer.checkOneTerm((Analyzer)a, (String)"steven\u2019s", (String)"steven");
        TestEnglishAnalyzer.checkOneTerm((Analyzer)a, (String)"steven\uff07s", (String)"steven");
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestEnglishAnalyzer.asSet((Object[])new String[]{"books"}), false);
        EnglishAnalyzer a = new EnglishAnalyzer(EnglishAnalyzer.getDefaultStopSet(), exclusionSet);
        TestEnglishAnalyzer.checkOneTerm((Analyzer)a, (String)"books", (String)"books");
        TestEnglishAnalyzer.checkOneTerm((Analyzer)a, (String)"book", (String)"book");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        EnglishAnalyzer a = new EnglishAnalyzer();
        TestEnglishAnalyzer.checkRandomData((Random)TestEnglishAnalyzer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }
}

