/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.en;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.en.EnglishMinimalStemFilter;

public class TestEnglishMinimalStemFilter
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new EnglishMinimalStemFilter((TokenStream)source));
            }
        };
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void testExamples() throws IOException {
        TestEnglishMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"queries", (String)"query");
        TestEnglishMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"phrases", (String)"phrase");
        TestEnglishMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"corpus", (String)"corpus");
        TestEnglishMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"stress", (String)"stress");
        TestEnglishMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"kings", (String)"king");
        TestEnglishMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"panels", (String)"panel");
        TestEnglishMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"aerodynamics", (String)"aerodynamic");
        TestEnglishMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"congress", (String)"congress");
        TestEnglishMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"serious", (String)"serious");
    }

    public void testRandomStrings() throws Exception {
        TestEnglishMinimalStemFilter.checkRandomData((Random)TestEnglishMinimalStemFilter.random(), (Analyzer)this.analyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new EnglishMinimalStemFilter((TokenStream)tokenizer));
            }
        };
        TestEnglishMinimalStemFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

