/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.en;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.VocabularyAssert;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.en.KStemFilter;

public class TestKStemmer
extends BaseTokenStreamTestCase {
    private Analyzer a;

    public void setUp() throws Exception {
        super.setUp();
        this.a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, true);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new KStemFilter((TokenStream)tokenizer));
            }
        };
    }

    public void tearDown() throws Exception {
        this.a.close();
        super.tearDown();
    }

    public void testRandomStrings() throws Exception {
        TestKStemmer.checkRandomData((Random)TestKStemmer.random(), (Analyzer)this.a, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testVocabulary() throws Exception {
        VocabularyAssert.assertVocabulary((Analyzer)this.a, (Path)this.getDataPath("kstemTestData.zip"), (String)"kstem_examples.txt");
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new KStemFilter((TokenStream)tokenizer));
            }
        };
        TestKStemmer.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

