/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.en;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.VocabularyAssert;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;

public class TestPorterStemFilter
extends BaseTokenStreamTestCase {
    private Analyzer a;

    public void setUp() throws Exception {
        super.setUp();
        this.a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer t = new MockTokenizer(MockTokenizer.KEYWORD, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)t, (TokenStream)new PorterStemFilter((TokenStream)t));
            }
        };
    }

    public void tearDown() throws Exception {
        this.a.close();
        super.tearDown();
    }

    public void testPorterStemFilter() throws Exception {
        VocabularyAssert.assertVocabulary((Analyzer)this.a, (Path)this.getDataPath("porterTestData.zip"), (String)"voc.txt", (String)"output.txt");
    }

    public void testWithKeywordAttribute() throws IOException {
        CharArraySet set = new CharArraySet(1, true);
        set.add("yourselves");
        MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        tokenizer.setReader((Reader)new StringReader("yourselves yours"));
        PorterStemFilter filter = new PorterStemFilter((TokenStream)new SetKeywordMarkerFilter((TokenStream)tokenizer, set));
        TestPorterStemFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"yourselves", "your"});
    }

    public void testRandomStrings() throws Exception {
        TestPorterStemFilter.checkRandomData((Random)TestPorterStemFilter.random(), (Analyzer)this.a, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new PorterStemFilter((TokenStream)tokenizer));
            }
        };
        TestPorterStemFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

