/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.es;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.es.SpanishAnalyzer;

public class TestSpanishAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new SpanishAnalyzer().close();
    }

    public void testBasics() throws IOException {
        SpanishAnalyzer a = new SpanishAnalyzer();
        TestSpanishAnalyzer.checkOneTerm((Analyzer)a, (String)"chicana", (String)"chican");
        TestSpanishAnalyzer.checkOneTerm((Analyzer)a, (String)"chicano", (String)"chican");
        TestSpanishAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"los", (String[])new String[0]);
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestSpanishAnalyzer.asSet((Object[])new String[]{"chicano"}), false);
        SpanishAnalyzer a = new SpanishAnalyzer(SpanishAnalyzer.getDefaultStopSet(), exclusionSet);
        TestSpanishAnalyzer.checkOneTerm((Analyzer)a, (String)"chicana", (String)"chican");
        TestSpanishAnalyzer.checkOneTerm((Analyzer)a, (String)"chicano", (String)"chicano");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        SpanishAnalyzer a = new SpanishAnalyzer();
        TestSpanishAnalyzer.checkRandomData((Random)TestSpanishAnalyzer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }
}

