/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.eu;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;

public class TestBasqueAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new BasqueAnalyzer().close();
    }

    public void testBasics() throws IOException {
        BasqueAnalyzer a = new BasqueAnalyzer();
        TestBasqueAnalyzer.checkOneTerm((Analyzer)a, (String)"zaldi", (String)"zaldi");
        TestBasqueAnalyzer.checkOneTerm((Analyzer)a, (String)"zaldiak", (String)"zaldi");
        TestBasqueAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"izan", (String[])new String[0]);
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestBasqueAnalyzer.asSet((Object[])new String[]{"zaldiak"}), false);
        BasqueAnalyzer a = new BasqueAnalyzer(BasqueAnalyzer.getDefaultStopSet(), exclusionSet);
        TestBasqueAnalyzer.checkOneTerm((Analyzer)a, (String)"zaldiak", (String)"zaldiak");
        TestBasqueAnalyzer.checkOneTerm((Analyzer)a, (String)"mendiari", (String)"mendi");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        BasqueAnalyzer a = new BasqueAnalyzer();
        TestBasqueAnalyzer.checkRandomData((Random)TestBasqueAnalyzer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }
}

