/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fa;

import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.util.Version;

public class TestPersianAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new PersianAnalyzer().close();
    }

    public void testBehaviorVerbs() throws Exception {
        PersianAnalyzer a = new PersianAnalyzer();
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0645\u06cc\u200c\u062e\u0648\u0631\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0645\u06cc\u200c\u062e\u0648\u0631\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0627\u0647\u062f \u062e\u0648\u0631\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062f\u0627\u0631\u062f \u0645\u06cc\u200c\u062e\u0648\u0631\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062f\u0627\u0634\u062a \u0645\u06cc\u200c\u062e\u0648\u0631\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647\u200c\u0627\u0633\u062a", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0645\u06cc\u200c\u062e\u0648\u0631\u062f\u0647\u200c\u0627\u0633\u062a", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0628\u0648\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0645\u06cc\u200c\u062e\u0648\u0631\u062f\u0647 \u0628\u0648\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0645\u06cc\u200c\u062e\u0648\u0631\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0628\u0648\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0645\u06cc\u200c\u062e\u0648\u0631\u062f\u0647 \u0628\u0648\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0645\u06cc\u200c\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0634\u062f\u0647\u200c\u0627\u0633\u062a", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0645\u06cc\u200c\u0634\u062f\u0647\u200c\u0627\u0633\u062a", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0634\u062f\u0647 \u0628\u0648\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0645\u06cc\u200c\u0634\u062f\u0647 \u0628\u0648\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u062e\u0648\u0627\u0647\u062f \u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062f\u0627\u0631\u062f \u062e\u0648\u0631\u062f\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062f\u0627\u0634\u062a \u062e\u0648\u0631\u062f\u0647 \u0645\u06cc\u200c\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0634\u0648\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0634\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0645\u06cc\u200c\u0634\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0634\u062f\u0647 \u0628\u0648\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0645\u06cc\u200c\u0634\u062f\u0647 \u0628\u0648\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0628\u062e\u0648\u0631\u062f", (String[])new String[]{"\u0628\u062e\u0648\u0631\u062f"});
        a.close();
    }

    public void testBehaviorVerbsDefective() throws Exception {
        PersianAnalyzer a = new PersianAnalyzer();
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0645\u064a \u062e\u0648\u0631\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0645\u064a \u062e\u0648\u0631\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0627\u0647\u062f \u062e\u0648\u0631\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062f\u0627\u0631\u062f \u0645\u064a \u062e\u0648\u0631\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062f\u0627\u0634\u062a \u0645\u064a \u062e\u0648\u0631\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0627\u0633\u062a", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0645\u064a \u062e\u0648\u0631\u062f\u0647 \u0627\u0633\u062a", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0628\u0648\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0645\u064a \u062e\u0648\u0631\u062f\u0647 \u0628\u0648\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0645\u064a \u062e\u0648\u0631\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0628\u0648\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0645\u064a \u062e\u0648\u0631\u062f\u0647 \u0628\u0648\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0645\u064a \u0634\u0648\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0645\u064a \u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0634\u062f\u0647 \u0627\u0633\u062a", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0645\u064a \u0634\u062f\u0647 \u0627\u0633\u062a", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0634\u062f\u0647 \u0628\u0648\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0645\u064a \u0634\u062f\u0647 \u0628\u0648\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u062e\u0648\u0627\u0647\u062f \u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062f\u0627\u0631\u062f \u062e\u0648\u0631\u062f\u0647 \u0645\u064a \u0634\u0648\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062f\u0627\u0634\u062a \u062e\u0648\u0631\u062f\u0647 \u0645\u064a \u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0634\u0648\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0634\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0645\u064a \u0634\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0634\u062f\u0647 \u0628\u0648\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0645\u064a \u0634\u062f\u0647 \u0628\u0648\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0628\u062e\u0648\u0631\u062f", (String[])new String[]{"\u0628\u062e\u0648\u0631\u062f"});
        a.close();
    }

    public void testBehaviorNouns() throws Exception {
        PersianAnalyzer a = new PersianAnalyzer();
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0628\u0631\u06af \u0647\u0627", (String[])new String[]{"\u0628\u0631\u06af"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0628\u0631\u06af\u200c\u0647\u0627", (String[])new String[]{"\u0628\u0631\u06af"});
        a.close();
    }

    public void testBehaviorNonPersian() throws Exception {
        PersianAnalyzer a = new PersianAnalyzer();
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"English test.", (String[])new String[]{"english", "test"});
        a.close();
    }

    public void testReusableTokenStream() throws Exception {
        PersianAnalyzer a = new PersianAnalyzer();
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u062e\u0648\u0631\u062f\u0647 \u0645\u064a \u0634\u062f\u0647 \u0628\u0648\u062f\u0647 \u0628\u0627\u0634\u062f", (String[])new String[]{"\u062e\u0648\u0631\u062f\u0647"});
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0628\u0631\u06af\u200c\u0647\u0627", (String[])new String[]{"\u0628\u0631\u06af"});
        a.close();
    }

    public void testCustomStopwords() throws Exception {
        PersianAnalyzer a = new PersianAnalyzer(new CharArraySet((Collection)TestPersianAnalyzer.asSet((Object[])new String[]{"the", "and", "a"}), false));
        TestPersianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"The quick brown fox.", (String[])new String[]{"quick", "brown", "fox"});
        a.close();
    }

    public void testDigits() throws Exception {
        PersianAnalyzer a = new PersianAnalyzer();
        TestPersianAnalyzer.checkOneTerm((Analyzer)a, (String)"\u06f1\u06f2\u06f3\u06f4", (String)"1234");
        a.close();
    }

    @Deprecated
    public void testDigitsBackCompat() throws Exception {
        PersianAnalyzer a = new PersianAnalyzer();
        a.setVersion(Version.LUCENE_5_3_0);
        TestPersianAnalyzer.checkOneTerm((Analyzer)a, (String)"\u06f1\u06f2\u06f3\u06f4", (String)"\u06f1\u06f2\u06f3\u06f4");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        PersianAnalyzer a = new PersianAnalyzer();
        TestPersianAnalyzer.checkRandomData((Random)TestPersianAnalyzer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }
}

