/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fa;

import java.io.Reader;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.fa.PersianCharFilter;

public class TestPersianCharFilter
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer());
            }

            protected Reader initReader(String fieldName, Reader reader) {
                return new PersianCharFilter(reader);
            }
        };
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void testBasics() throws Exception {
        TestPersianCharFilter.assertAnalyzesTo((Analyzer)this.analyzer, (String)"this is a\u200ctest", (String[])new String[]{"this", "is", "a", "test"});
    }

    public void testRandomStrings() throws Exception {
        TestPersianCharFilter.checkRandomData((Random)TestPersianCharFilter.random(), (Analyzer)this.analyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }
}

