/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fa;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.fa.PersianNormalizationFilter;

public class TestPersianNormalizationFilter
extends BaseTokenStreamTestCase {
    public void testFarsiYeh() throws IOException {
        this.check("\u0647\u0627\u06cc", "\u0647\u0627\u064a");
    }

    public void testYehBarree() throws IOException {
        this.check("\u0647\u0627\u06d2", "\u0647\u0627\u064a");
    }

    public void testKeheh() throws IOException {
        this.check("\u06a9\u0634\u0627\u0646\u062f\u0646", "\u0643\u0634\u0627\u0646\u062f\u0646");
    }

    public void testHehYeh() throws IOException {
        this.check("\u0643\u062a\u0627\u0628\u06c0", "\u0643\u062a\u0627\u0628\u0647");
    }

    public void testHehHamzaAbove() throws IOException {
        this.check("\u0643\u062a\u0627\u0628\u0647\u0654", "\u0643\u062a\u0627\u0628\u0647");
    }

    public void testHehGoal() throws IOException {
        this.check("\u0632\u0627\u062f\u06c1", "\u0632\u0627\u062f\u0647");
    }

    private void check(String input, String expected) throws IOException {
        MockTokenizer tokenStream = TestPersianNormalizationFilter.whitespaceMockTokenizer((String)input);
        PersianNormalizationFilter filter = new PersianNormalizationFilter((TokenStream)tokenStream);
        TestPersianNormalizationFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{expected});
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new PersianNormalizationFilter((TokenStream)tokenizer));
            }
        };
        TestPersianNormalizationFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

