/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fi;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;

public class TestFinnishAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new FinnishAnalyzer().close();
    }

    public void testBasics() throws IOException {
        FinnishAnalyzer a = new FinnishAnalyzer();
        TestFinnishAnalyzer.checkOneTerm((Analyzer)a, (String)"edelt\u00e4jiins\u00e4", (String)"edelt\u00e4j");
        TestFinnishAnalyzer.checkOneTerm((Analyzer)a, (String)"edelt\u00e4jist\u00e4\u00e4n", (String)"edelt\u00e4j");
        TestFinnishAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"olla", (String[])new String[0]);
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestFinnishAnalyzer.asSet((Object[])new String[]{"edelt\u00e4jist\u00e4\u00e4n"}), false);
        FinnishAnalyzer a = new FinnishAnalyzer(FinnishAnalyzer.getDefaultStopSet(), exclusionSet);
        TestFinnishAnalyzer.checkOneTerm((Analyzer)a, (String)"edelt\u00e4jiins\u00e4", (String)"edelt\u00e4j");
        TestFinnishAnalyzer.checkOneTerm((Analyzer)a, (String)"edelt\u00e4jist\u00e4\u00e4n", (String)"edelt\u00e4jist\u00e4\u00e4n");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        FinnishAnalyzer a = new FinnishAnalyzer();
        TestFinnishAnalyzer.checkRandomData((Random)TestFinnishAnalyzer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }
}

