/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;

public class TestFrenchAnalyzer
extends BaseTokenStreamTestCase {
    public void testAnalyzer() throws Exception {
        FrenchAnalyzer fa = new FrenchAnalyzer();
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"", (String[])new String[0]);
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"chien chat cheval", (String[])new String[]{"chien", "chat", "cheval"});
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"chien CHAT CHEVAL", (String[])new String[]{"chien", "chat", "cheval"});
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"  chien  ,? + = -  CHAT /: > CHEVAL", (String[])new String[]{"chien", "chat", "cheval"});
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"chien++", (String[])new String[]{"chien"});
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"mot \"entreguillemet\"", (String[])new String[]{"mot", "entreguilemet"});
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"Jean-Fran\u00e7ois", (String[])new String[]{"jean", "francoi"});
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"le la chien les aux chat du des \u00e0 cheval", (String[])new String[]{"chien", "chat", "cheval"});
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"lances chismes habitable chiste \u00e9l\u00e9ments captifs", (String[])new String[]{"lanc", "chism", "habitabl", "chist", "element", "captif"});
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"finissions souffrirent rugissante", (String[])new String[]{"finision", "soufrirent", "rugisant"});
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"C3PO aujourd'hui oeuf \u00ef\u00e2\u00f6\u00fb\u00e0\u00e4 anticonstitutionnellement Java++ ", (String[])new String[]{"c3po", "aujourd'hui", "oeuf", "\u00efa\u00f6ua\u00e4", "anticonstitutionel", "java"});
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"33Bis 1940-1945 1940:1945 (---i+++)*", (String[])new String[]{"33bi", "1940", "1945", "1940", "1945", "i"});
        fa.close();
    }

    public void testReusableTokenStream() throws Exception {
        FrenchAnalyzer fa = new FrenchAnalyzer();
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"le la chien les aux chat du des \u00e0 cheval", (String[])new String[]{"chien", "chat", "cheval"});
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"lances chismes habitable chiste \u00e9l\u00e9ments captifs", (String[])new String[]{"lanc", "chism", "habitabl", "chist", "element", "captif"});
        fa.close();
    }

    public void testExclusionTableViaCtor() throws Exception {
        CharArraySet set = new CharArraySet(1, true);
        set.add("habitable");
        FrenchAnalyzer fa = new FrenchAnalyzer(CharArraySet.EMPTY_SET, set);
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"habitable chiste", (String[])new String[]{"habitable", "chist"});
        fa.close();
        fa = new FrenchAnalyzer(CharArraySet.EMPTY_SET, set);
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"habitable chiste", (String[])new String[]{"habitable", "chist"});
        fa.close();
    }

    public void testElision() throws Exception {
        FrenchAnalyzer fa = new FrenchAnalyzer();
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)fa, (String)"voir l'embrouille", (String[])new String[]{"voir", "embrouil"});
        fa.close();
    }

    public void testStopwordsCasing() throws IOException {
        FrenchAnalyzer a = new FrenchAnalyzer();
        TestFrenchAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"Votre", (String[])new String[0]);
        a.close();
    }

    public void testRandomStrings() throws Exception {
        FrenchAnalyzer a = new FrenchAnalyzer();
        TestFrenchAnalyzer.checkRandomData((Random)TestFrenchAnalyzer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }

    public void testAccentInsensitive() throws Exception {
        FrenchAnalyzer a = new FrenchAnalyzer();
        TestFrenchAnalyzer.checkOneTerm((Analyzer)a, (String)"s\u00e9curitaires", (String)"securitair");
        TestFrenchAnalyzer.checkOneTerm((Analyzer)a, (String)"securitaires", (String)"securitair");
        a.close();
    }
}

