/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.VocabularyAssert;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.fr.FrenchLightStemFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;

public class TestFrenchLightStemFilter
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new FrenchLightStemFilter((TokenStream)source));
            }
        };
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void testExamples() throws IOException {
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"chevaux", (String)"cheval");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"cheval", (String)"cheval");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"hiboux", (String)"hibou");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"hibou", (String)"hibou");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"chant\u00e9s", (String)"chant");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"chanter", (String)"chant");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"chante", (String)"chant");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"chant", (String)"chant");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"baronnes", (String)"baron");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"barons", (String)"baron");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"baron", (String)"baron");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"peaux", (String)"peau");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"peau", (String)"peau");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"anneaux", (String)"aneau");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"anneau", (String)"aneau");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"neveux", (String)"neveu");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"neveu", (String)"neveu");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"affreux", (String)"afreu");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"affreuse", (String)"afreu");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"investissement", (String)"investi");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"investir", (String)"investi");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"assourdissant", (String)"asourdi");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"assourdir", (String)"asourdi");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"pratiquement", (String)"pratiqu");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"pratique", (String)"pratiqu");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"administrativement", (String)"administratif");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"administratif", (String)"administratif");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"justificatrice", (String)"justifi");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"justificateur", (String)"justifi");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"justifier", (String)"justifi");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"educatrice", (String)"eduqu");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"eduquer", (String)"eduqu");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"communicateur", (String)"comuniqu");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"communiquer", (String)"comuniqu");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"accompagnatrice", (String)"acompagn");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"accompagnateur", (String)"acompagn");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"administrateur", (String)"administr");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"administrer", (String)"administr");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"productrice", (String)"product");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"producteur", (String)"product");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"acheteuse", (String)"achet");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"acheteur", (String)"achet");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"planteur", (String)"plant");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"plante", (String)"plant");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"poreuse", (String)"poreu");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"poreux", (String)"poreu");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"plieuse", (String)"plieu");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"bijouti\u00e8re", (String)"bijouti");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"bijoutier", (String)"bijouti");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"caissi\u00e8re", (String)"caisi");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"caissier", (String)"caisi");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"abrasive", (String)"abrasif");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"abrasif", (String)"abrasif");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"folle", (String)"fou");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"fou", (String)"fou");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"personnelle", (String)"person");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"personne", (String)"person");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"compl\u00e8te", (String)"complet");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"complet", (String)"complet");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"aromatique", (String)"aromat");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"faiblesse", (String)"faibl");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"faible", (String)"faibl");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"patinage", (String)"patin");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"patin", (String)"patin");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"sonorisation", (String)"sono");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"ritualisation", (String)"rituel");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"rituel", (String)"rituel");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"nomination", (String)"nomin");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"disposition", (String)"dispos");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"dispose", (String)"dispos");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"1234555", (String)"1234555");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"12333345", (String)"12333345");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"1234", (String)"1234");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"abcdeff", (String)"abcdef");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"abcccddeef", (String)"abcdef");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"cr\u00e9\u00e9es", (String)"cre");
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"22hh00", (String)"22h00");
    }

    public void testVocabulary() throws IOException {
        VocabularyAssert.assertVocabulary((Analyzer)this.analyzer, (Path)this.getDataPath("frlighttestdata.zip"), (String)"frlight.txt");
    }

    public void testKeyword() throws IOException {
        final CharArraySet exclusionSet = new CharArraySet((Collection)TestFrenchLightStemFilter.asSet((Object[])new String[]{"chevaux"}), false);
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                SetKeywordMarkerFilter sink = new SetKeywordMarkerFilter((TokenStream)source, exclusionSet);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new FrenchLightStemFilter((TokenStream)sink));
            }
        };
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)a, (String)"chevaux", (String)"chevaux");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        TestFrenchLightStemFilter.checkRandomData((Random)TestFrenchLightStemFilter.random(), (Analyzer)this.analyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new FrenchLightStemFilter((TokenStream)tokenizer));
            }
        };
        TestFrenchLightStemFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

