/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.VocabularyAssert;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.fr.FrenchMinimalStemFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;

public class TestFrenchMinimalStemFilter
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new FrenchMinimalStemFilter((TokenStream)source));
            }
        };
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void testExamples() throws IOException {
        TestFrenchMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"chevaux", (String)"cheval");
        TestFrenchMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"hiboux", (String)"hibou");
        TestFrenchMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"chant\u00e9s", (String)"chant");
        TestFrenchMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"chanter", (String)"chant");
        TestFrenchMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"chante", (String)"chant");
        TestFrenchMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"baronnes", (String)"baron");
        TestFrenchMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"barons", (String)"baron");
        TestFrenchMinimalStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"baron", (String)"baron");
    }

    public void testKeyword() throws IOException {
        final CharArraySet exclusionSet = new CharArraySet((Collection)TestFrenchMinimalStemFilter.asSet((Object[])new String[]{"chevaux"}), false);
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                SetKeywordMarkerFilter sink = new SetKeywordMarkerFilter((TokenStream)source, exclusionSet);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new FrenchMinimalStemFilter((TokenStream)sink));
            }
        };
        TestFrenchMinimalStemFilter.checkOneTerm((Analyzer)a, (String)"chevaux", (String)"chevaux");
        a.close();
    }

    public void testVocabulary() throws IOException {
        VocabularyAssert.assertVocabulary((Analyzer)this.analyzer, (Path)this.getDataPath("frminimaltestdata.zip"), (String)"frminimal.txt");
    }

    public void testRandomStrings() throws Exception {
        TestFrenchMinimalStemFilter.checkRandomData((Random)TestFrenchMinimalStemFilter.random(), (Analyzer)this.analyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new FrenchMinimalStemFilter((TokenStream)tokenizer));
            }
        };
        TestFrenchMinimalStemFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

