/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ga;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ga.IrishAnalyzer;

public class TestIrishAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new IrishAnalyzer().close();
    }

    public void testBasics() throws IOException {
        IrishAnalyzer a = new IrishAnalyzer();
        TestIrishAnalyzer.checkOneTerm((Analyzer)a, (String)"siopad\u00f3ireacht", (String)"siopad\u00f3ir");
        TestIrishAnalyzer.checkOneTerm((Analyzer)a, (String)"s\u00edceapatacha", (String)"s\u00edceapaite");
        TestIrishAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"le", (String[])new String[0]);
        a.close();
    }

    public void testContractions() throws IOException {
        IrishAnalyzer a = new IrishAnalyzer();
        TestIrishAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"b'fhearr m'athair", (String[])new String[]{"fearr", "athair"});
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestIrishAnalyzer.asSet((Object[])new String[]{"feirmeoireacht"}), false);
        IrishAnalyzer a = new IrishAnalyzer(IrishAnalyzer.getDefaultStopSet(), exclusionSet);
        TestIrishAnalyzer.checkOneTerm((Analyzer)a, (String)"feirmeoireacht", (String)"feirmeoireacht");
        TestIrishAnalyzer.checkOneTerm((Analyzer)a, (String)"siopad\u00f3ireacht", (String)"siopad\u00f3ir");
        a.close();
    }

    public void testHyphens() throws IOException {
        IrishAnalyzer a = new IrishAnalyzer();
        TestIrishAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"n-athair", (String[])new String[]{"athair"}, (int[])new int[]{2});
        a.close();
    }

    public void testRandomStrings() throws Exception {
        IrishAnalyzer a = new IrishAnalyzer();
        TestIrishAnalyzer.checkRandomData((Random)TestIrishAnalyzer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }
}

