/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ga;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.ga.IrishLowerCaseFilter;

public class TestIrishLowerCaseFilter
extends BaseTokenStreamTestCase {
    public void testIrishLowerCaseFilter() throws Exception {
        MockTokenizer stream = TestIrishLowerCaseFilter.whitespaceMockTokenizer((String)"nAthair tUISCE hARD");
        IrishLowerCaseFilter filter = new IrishLowerCaseFilter((TokenStream)stream);
        TestIrishLowerCaseFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"n-athair", "t-uisce", "hard"});
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new IrishLowerCaseFilter((TokenStream)tokenizer));
            }
        };
        TestIrishLowerCaseFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

