/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.gl;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.gl.GalicianAnalyzer;

public class TestGalicianAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new GalicianAnalyzer().close();
    }

    public void testBasics() throws IOException {
        GalicianAnalyzer a = new GalicianAnalyzer();
        TestGalicianAnalyzer.checkOneTerm((Analyzer)a, (String)"correspondente", (String)"correspond");
        TestGalicianAnalyzer.checkOneTerm((Analyzer)a, (String)"corresponder\u00e1", (String)"correspond");
        TestGalicianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"e", (String[])new String[0]);
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestGalicianAnalyzer.asSet((Object[])new String[]{"correspondente"}), false);
        GalicianAnalyzer a = new GalicianAnalyzer(GalicianAnalyzer.getDefaultStopSet(), exclusionSet);
        TestGalicianAnalyzer.checkOneTerm((Analyzer)a, (String)"correspondente", (String)"correspondente");
        TestGalicianAnalyzer.checkOneTerm((Analyzer)a, (String)"corresponder\u00e1", (String)"correspond");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        GalicianAnalyzer analyzer = new GalicianAnalyzer();
        TestGalicianAnalyzer.checkRandomData((Random)TestGalicianAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

