/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.gl;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.gl.GalicianMinimalStemFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;

public class TestGalicianMinimalStemFilter
extends BaseTokenStreamTestCase {
    private Analyzer a;

    public void setUp() throws Exception {
        super.setUp();
        this.a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new GalicianMinimalStemFilter((TokenStream)tokenizer));
            }
        };
    }

    public void tearDown() throws Exception {
        this.a.close();
        super.tearDown();
    }

    public void testPlural() throws Exception {
        TestGalicianMinimalStemFilter.checkOneTerm((Analyzer)this.a, (String)"elefantes", (String)"elefante");
        TestGalicianMinimalStemFilter.checkOneTerm((Analyzer)this.a, (String)"elefante", (String)"elefante");
        TestGalicianMinimalStemFilter.checkOneTerm((Analyzer)this.a, (String)"kal\u00f3res", (String)"kal\u00f3r");
        TestGalicianMinimalStemFilter.checkOneTerm((Analyzer)this.a, (String)"kal\u00f3r", (String)"kal\u00f3r");
    }

    public void testExceptions() throws Exception {
        TestGalicianMinimalStemFilter.checkOneTerm((Analyzer)this.a, (String)"mas", (String)"mas");
        TestGalicianMinimalStemFilter.checkOneTerm((Analyzer)this.a, (String)"barcelon\u00eas", (String)"barcelon\u00eas");
    }

    public void testKeyword() throws IOException {
        final CharArraySet exclusionSet = new CharArraySet((Collection)TestGalicianMinimalStemFilter.asSet((Object[])new String[]{"elefantes"}), false);
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                SetKeywordMarkerFilter sink = new SetKeywordMarkerFilter((TokenStream)source, exclusionSet);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new GalicianMinimalStemFilter((TokenStream)sink));
            }
        };
        TestGalicianMinimalStemFilter.checkOneTerm((Analyzer)a, (String)"elefantes", (String)"elefantes");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        TestGalicianMinimalStemFilter.checkRandomData((Random)TestGalicianMinimalStemFilter.random(), (Analyzer)this.a, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new GalicianMinimalStemFilter((TokenStream)tokenizer));
            }
        };
        TestGalicianMinimalStemFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

