/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hi;

import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.hi.HindiAnalyzer;
import org.apache.lucene.util.Version;

public class TestHindiAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new HindiAnalyzer().close();
    }

    public void testBasics() throws Exception {
        HindiAnalyzer a = new HindiAnalyzer();
        TestHindiAnalyzer.checkOneTerm((Analyzer)a, (String)"\u0939\u093f\u0928\u094d\u0926\u0940", (String)"\u0939\u093f\u0902\u0926");
        TestHindiAnalyzer.checkOneTerm((Analyzer)a, (String)"\u0939\u093f\u0902\u0926\u0940", (String)"\u0939\u093f\u0902\u0926");
        a.close();
    }

    public void testExclusionSet() throws Exception {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestHindiAnalyzer.asSet((Object[])new String[]{"\u0939\u093f\u0902\u0926\u0940"}), false);
        HindiAnalyzer a = new HindiAnalyzer(HindiAnalyzer.getDefaultStopSet(), exclusionSet);
        TestHindiAnalyzer.checkOneTerm((Analyzer)a, (String)"\u0939\u093f\u0902\u0926\u0940", (String)"\u0939\u093f\u0902\u0926\u0940");
        a.close();
    }

    public void testDigits() throws Exception {
        HindiAnalyzer a = new HindiAnalyzer();
        TestHindiAnalyzer.checkOneTerm((Analyzer)a, (String)"\u0967\u0968\u0969\u096a", (String)"1234");
        a.close();
    }

    @Deprecated
    public void testDigitsBackCompat() throws Exception {
        HindiAnalyzer a = new HindiAnalyzer();
        a.setVersion(Version.LUCENE_5_3_0);
        TestHindiAnalyzer.checkOneTerm((Analyzer)a, (String)"\u0967\u0968\u0969\u096a", (String)"\u0967\u0968\u0969\u096a");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        HindiAnalyzer analyzer = new HindiAnalyzer();
        TestHindiAnalyzer.checkRandomData((Random)TestHindiAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

