/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hi;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestHindiFilters
extends BaseTokenStreamFactoryTestCase {
    public void testIndicNormalizer() throws Exception {
        StringReader reader = new StringReader("\u09a4\u09cd\u200d \u0905\u093e\u0948\u0930");
        MockTokenizer stream = TestHindiFilters.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("IndicNormalization", new String[0]).create((TokenStream)stream);
        TestHindiFilters.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\u09ce", "\u0914\u0930"});
    }

    public void testHindiNormalizer() throws Exception {
        StringReader reader = new StringReader("\u0958\u093f\u0924\u093e\u092c");
        MockTokenizer stream = TestHindiFilters.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("IndicNormalization", new String[0]).create((TokenStream)stream);
        stream = this.tokenFilterFactory("HindiNormalization", new String[0]).create((TokenStream)stream);
        TestHindiFilters.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\u0915\u093f\u0924\u093e\u092c"});
    }

    public void testStemmer() throws Exception {
        StringReader reader = new StringReader("\u0915\u093f\u0924\u093e\u092c\u0947\u0902");
        MockTokenizer stream = TestHindiFilters.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("IndicNormalization", new String[0]).create((TokenStream)stream);
        stream = this.tokenFilterFactory("HindiNormalization", new String[0]).create((TokenStream)stream);
        stream = this.tokenFilterFactory("HindiStem", new String[0]).create((TokenStream)stream);
        TestHindiFilters.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\u0915\u093f\u0924\u093e\u092c"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestHindiFilters.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("IndicNormalization", "bogusArg", "bogusValue"));
        TestHindiFilters.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
        expected = (IllegalArgumentException)TestHindiFilters.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("HindiNormalization", "bogusArg", "bogusValue"));
        TestHindiFilters.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
        expected = (IllegalArgumentException)TestHindiFilters.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("HindiStem", "bogusArg", "bogusValue"));
        TestHindiFilters.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

