/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hi;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.hi.HindiNormalizationFilter;

public class TestHindiNormalizer
extends BaseTokenStreamTestCase {
    public void testBasics() throws IOException {
        this.check("\u0905\u0901\u0917\u0930\u0947\u091c\u093c\u0940", "\u0905\u0902\u0917\u0930\u0947\u091c\u093f");
        this.check("\u0905\u0901\u0917\u0930\u0947\u091c\u0940", "\u0905\u0902\u0917\u0930\u0947\u091c\u093f");
        this.check("\u0905\u0901\u0917\u094d\u0930\u0947\u091c\u093c\u0940", "\u0905\u0902\u0917\u0930\u0947\u091c\u093f");
        this.check("\u0905\u0901\u0917\u094d\u0930\u0947\u091c\u0940", "\u0905\u0902\u0917\u0930\u0947\u091c\u093f");
        this.check("\u0905\u0902\u0917\u0930\u0947\u091c\u093c\u0940", "\u0905\u0902\u0917\u0930\u0947\u091c\u093f");
        this.check("\u0905\u0902\u0917\u0930\u0947\u091c\u0940", "\u0905\u0902\u0917\u0930\u0947\u091c\u093f");
        this.check("\u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940", "\u0905\u0902\u0917\u0930\u0947\u091c\u093f");
        this.check("\u0905\u0902\u0917\u094d\u0930\u0947\u091c\u0940", "\u0905\u0902\u0917\u0930\u0947\u091c\u093f");
    }

    public void testDecompositions() throws IOException {
        this.check("\u0958\u093f\u0924\u093e\u092c", "\u0915\u093f\u0924\u093e\u092c");
        this.check("\u095e\u0930\u094d\u095b", "\u092b\u0930\u091c");
        this.check("\u0958\u0930\u094d\u095b", "\u0915\u0930\u091c");
        this.check("\u0931\u0934\u0959\u095a\u095c\u095d\u095f", "\u0930\u0933\u0916\u0917\u0921\u0922\u092f");
        this.check("\u0936\u093e\u0930\u094d\u200d\u092e\u093e", "\u0936\u093e\u0930\u092e\u093e");
        this.check("\u0936\u093e\u0930\u094d\u200c\u092e\u093e", "\u0936\u093e\u0930\u092e\u093e");
        this.check("\u0945\u0946\u0949\u094a\u090d\u090e\u0911\u0912\u0972", "\u0947\u0947\u094b\u094b\u090f\u090f\u0913\u0913\u0905");
        this.check("\u0906\u0908\u090a\u0960\u0961\u0910\u0914\u0940\u0942\u0944\u0963\u0948\u094c", "\u0905\u0907\u0909\u090b\u090c\u090f\u0913\u093f\u0941\u0943\u0962\u0947\u094b");
    }

    private void check(String input, String output) throws IOException {
        MockTokenizer tokenizer = TestHindiNormalizer.whitespaceMockTokenizer((String)input);
        HindiNormalizationFilter tf = new HindiNormalizationFilter((TokenStream)tokenizer);
        TestHindiNormalizer.assertTokenStreamContents((TokenStream)tf, (String[])new String[]{output});
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new HindiNormalizationFilter((TokenStream)tokenizer));
            }
        };
        TestHindiNormalizer.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

