/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hi;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.hi.HindiStemFilter;

public class TestHindiStemmer
extends BaseTokenStreamTestCase {
    public void testMasculineNouns() throws IOException {
        this.check("\u0932\u0921\u0915\u093e", "\u0932\u0921\u0915");
        this.check("\u0932\u0921\u0915\u0947", "\u0932\u0921\u0915");
        this.check("\u0932\u0921\u0915\u094b\u0902", "\u0932\u0921\u0915");
        this.check("\u0917\u0941\u0930\u0941", "\u0917\u0941\u0930");
        this.check("\u0917\u0941\u0930\u0941\u0913\u0902", "\u0917\u0941\u0930");
        this.check("\u0926\u094b\u0938\u094d\u0924", "\u0926\u094b\u0938\u094d\u0924");
        this.check("\u0926\u094b\u0938\u094d\u0924\u094b\u0902", "\u0926\u094b\u0938\u094d\u0924");
    }

    public void testFeminineNouns() throws IOException {
        this.check("\u0932\u0921\u0915\u0940", "\u0932\u0921\u0915");
        this.check("\u0932\u0921\u0915\u093f\u092f\u094b\u0902", "\u0932\u0921\u0915");
        this.check("\u0915\u093f\u0924\u093e\u092c", "\u0915\u093f\u0924\u093e\u092c");
        this.check("\u0915\u093f\u0924\u093e\u092c\u0947\u0902", "\u0915\u093f\u0924\u093e\u092c");
        this.check("\u0915\u093f\u0924\u093e\u092c\u094b\u0902", "\u0915\u093f\u0924\u093e\u092c");
        this.check("\u0906\u0927\u094d\u092f\u093e\u092a\u0940\u0915\u093e", "\u0906\u0927\u094d\u092f\u093e\u092a\u0940\u0915");
        this.check("\u0906\u0927\u094d\u092f\u093e\u092a\u0940\u0915\u093e\u090f\u0902", "\u0906\u0927\u094d\u092f\u093e\u092a\u0940\u0915");
        this.check("\u0906\u0927\u094d\u092f\u093e\u092a\u0940\u0915\u093e\u0913\u0902", "\u0906\u0927\u094d\u092f\u093e\u092a\u0940\u0915");
    }

    public void testVerbs() throws IOException {
        this.check("\u0916\u093e\u0928\u093e", "\u0916\u093e");
        this.check("\u0916\u093e\u0924\u093e", "\u0916\u093e");
        this.check("\u0916\u093e\u0924\u0940", "\u0916\u093e");
        this.check("\u0916\u093e", "\u0916\u093e");
    }

    public void testExceptions() throws IOException {
        this.check("\u0915\u0920\u093f\u0928\u093e\u0907\u092f\u093e\u0902", "\u0915\u0920\u093f\u0928");
        this.check("\u0915\u0920\u093f\u0928", "\u0915\u0920\u093f\u0928");
    }

    private void check(String input, String output) throws IOException {
        MockTokenizer tokenizer = TestHindiStemmer.whitespaceMockTokenizer((String)input);
        HindiStemFilter tf = new HindiStemFilter((TokenStream)tokenizer);
        TestHindiStemmer.assertTokenStreamContents((TokenStream)tf, (String[])new String[]{output});
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new HindiStemFilter((TokenStream)tokenizer));
            }
        };
        TestHindiStemmer.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

