/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hu;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;

public class TestHungarianAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new HungarianAnalyzer().close();
    }

    public void testBasics() throws IOException {
        HungarianAnalyzer a = new HungarianAnalyzer();
        TestHungarianAnalyzer.checkOneTerm((Analyzer)a, (String)"babakocsi", (String)"babakocs");
        TestHungarianAnalyzer.checkOneTerm((Analyzer)a, (String)"babakocsij\u00e1\u00e9rt", (String)"babakocs");
        TestHungarianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u00e1ltal", (String[])new String[0]);
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestHungarianAnalyzer.asSet((Object[])new String[]{"babakocsi"}), false);
        HungarianAnalyzer a = new HungarianAnalyzer(HungarianAnalyzer.getDefaultStopSet(), exclusionSet);
        TestHungarianAnalyzer.checkOneTerm((Analyzer)a, (String)"babakocsi", (String)"babakocsi");
        TestHungarianAnalyzer.checkOneTerm((Analyzer)a, (String)"babakocsij\u00e1\u00e9rt", (String)"babakocs");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        HungarianAnalyzer analyzer = new HungarianAnalyzer();
        TestHungarianAnalyzer.checkRandomData((Random)TestHungarianAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

